﻿using System;
using System.Collections.Generic;
using System.Web.UI;
using System.Data.OleDb;
using DataAccess;

namespace VMT
{
    public partial class RateTypes_businessuint : System.Web.UI.Page
    {
        string m_SP_VDM_BU_RATETYPES_INS_DEL = Properties.Settings.Default.SP_VDM_BU_RATETYPES_INS_DEL;
        string m_SP_SELECT_RATETYPES_BU = Properties.Settings.Default.SP_SELECT_RATETYPES_BU;
        string m_SP_SELECT_BU_NOT_RATETYPES = Properties.Settings.Default.SP_SELECT_BU_NOT_RATETYPES;
        string m_SP_SELECT_BU_RATETYPES = Properties.Settings.Default.SP_SELECT_BU_RATETYPES;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Business Unit (Rate Types)";

        protected void Page_Load(object sender, EventArgs e)
        {
           

            if (!Page.IsPostBack)
            {

                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
                //if (userRole == "Edit")
                //{
                //    btn_add.Visible = true;
                //    btn_delete.Visible = true;
                //}
                //else
                //{
                //    btn_add.Visible = false;
                //    btn_delete.Visible = false;
                //}

                bindBusinessUnit();
                bindBusinessUnitNotRateTypes();
                bindBusinessUnitExistingRateTypes();
            }
        }

        protected void btn_add_Click(object sender, EventArgs e)
        {
            AddUpdate("INSERT");
        }


        private void AddUpdate(string strOperation)
        {
            if (ddl_BUnit.SelectedIndex == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Choose Business Unit!')", true);
                ddl_BUnit.Focus();
                return;
            }
            int Rate_Type_id = 0;
            if (strOperation == "DELETE")
            {
                if (lst_BUnitCompany.SelectedIndex == -1)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Choose Rate Type to Add')", true);
                    lst_BUnitCompany.Focus();
                    return;
                }
                else
                {
                    Rate_Type_id = Int32.Parse(lst_BUnitCompany.SelectedValue);
                }
            }

            else
            {
                if (ddl_RateType.SelectedIndex == -1)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Choose Rate Type!')", true);
                    ddl_RateType.Focus();
                    return;
                }
                else
                {
                    Rate_Type_id = Int32.Parse(ddl_RateType.SelectedValue);
                }
            }





            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_BUnit.SelectedValue.ToString()));
                sqlParams.Add(new OleDbParameter("V_RATE_TYPE_ID", Rate_Type_id));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                //  sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_BU_RATETYPES_INS_DEL, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                bindBusinessUnitNotRateTypes();
                bindBusinessUnitExistingRateTypes();

                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Company name already exists')", true);
            }

        }
        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SELECT_RATETYPES_BU, ddl_BUnit);
            }
            catch
            {
            }
        }
        void bindBusinessUnitNotRateTypes()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_BUnit.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SELECT_BU_NOT_RATETYPES, OledbParams, ddl_RateType);
            }
            catch
            {
            }
        }
        void bindBusinessUnitExistingRateTypes()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_BUnit.SelectedValue));
                DataAccessUtility.BindListboxWithConditionViaProcedure(m_SP_SELECT_BU_RATETYPES, OledbParams, lst_BUnitCompany);
            }
            catch
            {
            }
        }

        protected void ddl_BUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindBusinessUnitNotRateTypes();
            bindBusinessUnitExistingRateTypes();
        }

        protected void ddl_BUnit_DataBound(object sender, EventArgs e)
        {
            bindBusinessUnitNotRateTypes();
            bindBusinessUnitExistingRateTypes();
        }

        protected void btn_delete_Click(object sender, EventArgs e)
        {
            AddUpdate("DELETE");
        }
    }
}