﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;

namespace VMT
{
    public partial class RateAssignment : System.Web.UI.Page
    {
        string m_SP_VDM_SELECT_BU_RATE_ASSN = Properties.Settings.Default.SP_VDM_SELECT_BU_RATE_ASSN;
        string m_SP_VDM_SELECT_YEAR_RATE_ASSN = Properties.Settings.Default.SP_VDM_SELECT_YEAR_RATE_ASSN;
        string m_SP_VDM_SELECT_COMP_RATE_ASSN = Properties.Settings.Default.SP_VDM_SELECT_COMP_RATE_ASSN;
        string m_SP_VDM_SELECT_RTYPE_RATE_ASSGN = Properties.Settings.Default.SP_VDM_SELECT_RTYPE_RATE_ASSGN;
        string m_SP_VDM_SELECT_RATEASSIGNMENT = Properties.Settings.Default.SP_VDM_SELECT_RATEASSIGNMENT;
        string m_SP_SELECT_UOM_RATEASSIGNMENT = Properties.Settings.Default.SP_SELECT_UOM_RATEASSIGNMENT;
        string m_SP_VDM_RATEASSIGNMENT_INS_UPD = Properties.Settings.Default.SP_VDM_RATEASSIGNMENT_INS_UPD;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Company Rate Assignment";

        protected void Page_Load(object sender, EventArgs e)
        {
           

            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            //if (userRole == "Edit")
            //{
            //    rowAdd.Visible = true;
            //    rowAddBtn.Visible = true;
            //}
            //else
            //{
            //    rowAdd.Visible = false;
            //    rowAddBtn.Visible = false;
            //}

            if (!Page.IsPostBack)
            {

                //checks user role
                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }
                hdn_role.Value = userRole;
                bindBusinessUnit();

                ddl_Bunit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                bindYear();
               
                ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
               
                bindCompany();
                CreateNew.Visible = false;
            }
        }

        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_BU_RATE_ASSN, ddl_Bunit);
            }
            catch
            {
            }
        }
        void bindYear()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_YEAR_RATE_ASSN, ddl_Year);
            }
            catch
            {
            }
        }

        void bindCompany()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_COMP_RATE_ASSN, ddl_Company);
            }
            catch
            {
            }
        }
                
        public int intnull(string inttext)
        {
            int value1 = 0;
            try
            {
                value1 = Convert.ToInt32(inttext);
            }
            catch (Exception ex)
            {
                value1 = 0;
            }
            return value1;
        }
        void bindrateType()
        {

            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_COMPANY_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_RTYPE_RATE_ASSGN, OledbParams, ddl_RateTypes);
            }
            catch
            {
            }
        }
        private void bindGrid()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_COMPANY_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VDM_SELECT_RATEASSIGNMENT, OledbParams, gdv_Rate_Company);
            }
            catch
            {
            }
        }
        void getUOM()
        {
            try
            {
                if (ddl_RateTypes.SelectedIndex >= 0)
                {
                    DataSet ds = new DataSet();
                    List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
                    OleDbParams.Add(new OleDbParameter("V_RATE_TYPE_ID", ddl_RateTypes.SelectedValue));
                    ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SELECT_UOM_RATEASSIGNMENT, OleDbParams);

                    //bind the fields 

                    lbl_UOM.Text = ds.Tables[0].Rows[0]["UOM"].ToString();
                }
                else
                {
                    lbl_UOM.Text = "";
                }
            }
            catch
            {
            }
        }
        private void AddDelete(string strOperation, int V_BUSINESS_UNIT_ID, int V_RATE_YEAR_ID, int V_COMPANY_ID, int V_RATE_TYPE_ID, double V_RATE_TYPE_AMOUNT)
        {
            string retVal = string.Empty;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                sqlParams.Add(new OleDbParameter("V_RATE_YEAR_ID", V_RATE_YEAR_ID));
                sqlParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                sqlParams.Add(new OleDbParameter("V_RATE_TYPE_ID", V_RATE_TYPE_ID));
                sqlParams.Add(new OleDbParameter("V_RATE_TYPE_AMOUNT", V_RATE_TYPE_AMOUNT));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                // sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsUpdDelViaStoreProcedureParam(m_SP_VDM_RATEASSIGNMENT_INS_UPD, sqlParams);

                //ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + retVal.ToString() + "')", true);

            }
            catch { }
            finally
            {
            }
        }
        
        void resetControl()
        {
            txt_Rateamount.Text = "";


        }
        
        protected void btn_addRates_Click(object sender, EventArgs e)
        {

            if (txt_Rateamount.Text.Trim() == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate Amount could not be blank!')", true);
                txt_Rateamount.Focus();
                return;
            }

            if (ddl_RateTypes.SelectedValue == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select Rate Type!')", true);
                ddl_RateTypes.Focus();
                return;
            }
            double V_RATE_TYPE_AMOUNT = 0.0;
            try
            {
                V_RATE_TYPE_AMOUNT = Convert.ToDouble(txt_Rateamount.Text.Trim());
            }
            catch (Exception ex)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate Amount could not be non-Numeric!')", true);
                txt_Rateamount.Focus();
                return;
            }

            string strOperation = "";
            int V_BUSINESS_UNIT_ID = 0;
            int V_RATE_YEAR_ID = 0;
            int V_COMPANY_ID = 0;
            int V_RATE_TYPE_ID = 0;

            try
            {
                strOperation = "INSERT";
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                V_RATE_YEAR_ID = Convert.ToInt32(ddl_Year.SelectedValue);
                V_RATE_TYPE_ID = Convert.ToInt32(ddl_RateTypes.SelectedValue);
                V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue);

                AddDelete(strOperation, V_BUSINESS_UNIT_ID, V_RATE_YEAR_ID, V_COMPANY_ID, V_RATE_TYPE_ID, V_RATE_TYPE_AMOUNT);
                bindGrid();
                //bindGridWorkAreas();
                bindrateType();
                resetControl();
            }
            catch
            {
            }
        }

        protected void ddl_Company_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindrateType();
            //bindWorkAreas();
            bindGrid();
        }

        protected void btnshowhide_Click(object sender, ImageClickEventArgs e)
        {
            if (CreateNew.Visible == true)
            {
                CreateNew.Visible = false;
                btnshowhide.ImageUrl = "resource_gallery/graphics/plus.png";
            }
            else
            {
                btnshowhide.ImageUrl = "resource_gallery/graphics/minus.png";
                CreateNew.Visible = true;
            }
        }

        protected void ddl_RateTypes_SelectedIndexChanged(object sender, EventArgs e)
        {
            getUOM();
        }

        protected void ddl_RateTypes_DataBound(object sender, EventArgs e)
        {
            getUOM();
        }
        
        protected void gdv_Rate_Company_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            try
            {
                int V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue.ToString());
                int V_RATE_YEAR_ID = Convert.ToInt32(ddl_Year.SelectedValue.ToString());
                int V_COMPANY_ID = Convert.ToInt32(ddl_Company.SelectedValue.ToString());
                GridViewRow row = (GridViewRow)gdv_Rate_Company.Rows[e.RowIndex];
                
                int V_RATE_TYPE_ID = Convert.ToInt32((row.FindControl("lbl_RATE_TYPE_ID") as Label).Text);

                double V_RATE_TYPE_AMOUNT = 0.0;
                AddDelete("DELETE", V_BUSINESS_UNIT_ID, V_RATE_YEAR_ID, V_COMPANY_ID, V_RATE_TYPE_ID, V_RATE_TYPE_AMOUNT);

                bindGrid();
                bindrateType();
                resetControl();
            }
            catch
            {
            }
        }

        protected void ddl_gridWorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindrateType();
        }

        protected void ddl_gridWorkArea_DataBound(object sender, EventArgs e)
        {
            bindrateType();
        }

        protected void gdv_Rate_Company_RowCreated(object sender, GridViewRowEventArgs e)
        {

            e.Row.Cells[3].Visible = false;
            //checks user role
            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            if (hdn_role.Value == "3")
            {
                e.Row.Cells[4].Visible = true;
            }
            else
            {
                e.Row.Cells[4].Visible = false;
            }
        }

        protected void ddl_Bunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (ddl_Year.SelectedIndex > 0 && ddl_Company.SelectedIndex > 0)
            {
                bindGrid();
                bindrateType();
            }
        }

        protected void ddl_Year_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (ddl_Bunit.SelectedIndex > 0 && ddl_Company.SelectedIndex > 0)
            {
                bindGrid();
                bindrateType();
            }
        }
    }
}