﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Data.SqlClient;
using DataAccess;
using System.IO;

namespace VMT
{
    public partial class OpenCloseforInspection : System.Web.UI.Page
    {
        int m_InspectionStatus = 0;
        string m_SP_VDM_INP_SELECT_BU = Properties.Settings.Default.SP_VDM_INP_SELECT_BU;
        string m_SP_VDM_INP_SELECT_YR = Properties.Settings.Default.SP_VDM_INP_SELECT_YR;
        string m_SP_VDM_INP_SELECT_EVNTCODE = Properties.Settings.Default.SP_VDM_INP_SELECT_EVNTCODE;
        string m_SP_VDM_INP_SELECT_WAINSPECTION = Properties.Settings.Default.SP_VDM_INP_SELECT_WAINSPECTION;
        string m_SP_VDM_INP_UPDATE_INSP_STATUS = Properties.Settings.Default.SP_VDM_INP_UPDATE_INSP_STATUS;
        
        

        string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Project/Event Inspection";

        protected void Page_Load(object sender, EventArgs e)
        {
           

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            InspectionStatus();
            if (!Page.IsPostBack)
            {
                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                hdn_role.Value = userRole;
                BindBusinessUnit();
                
                ddlBUnit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                BindYear();
               
            }
        }
        protected void InspectionStatus()
        {
            if (rbt_open.Checked == true)
            {
                m_InspectionStatus = 5;
            }

            else
            {
                m_InspectionStatus = 6;
            }
        }
        void BindBusinessUnit()
        {
            try
            {

                int V_INSPECTION_STATUS = 0;

                V_INSPECTION_STATUS = m_InspectionStatus;

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_INSPECTION_STATUS", V_INSPECTION_STATUS));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_INP_SELECT_BU, OledbParams, ddlBUnit);
            }
            catch
            {
            }


        }
        void BindYear()
        {
            try
            {

                int V_BUSINESS_UNIT_ID = 0;
                int V_INSPECTION_STATUS = 0;

                V_INSPECTION_STATUS = m_InspectionStatus;
                try
                {

                    V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                }
                catch
                {
                }

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_INSPECTION_STATUS", V_INSPECTION_STATUS));
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_INP_SELECT_YR, OledbParams, ddlYear);
            }
            catch
            {
            }


        }

        void BindEventCode()
        {
            try
            {
                int V_BUSINESS_UNIT_ID = 0;
                int V_YEAR = 0;
                int V_INSPECTION_STATUS = 0;

                V_INSPECTION_STATUS = m_InspectionStatus;
                try
                {

                    V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                }
                catch
                {
                }
                V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_INSPECTION_STATUS", V_INSPECTION_STATUS));
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_INP_SELECT_EVNTCODE, OledbParams, ddlEventCode);
            }
            catch
            {
            }


        }
        void BindGrid()
        {
            try
            {
                int V_BUSINESS_UNIT_ID = 0;
                int V_YEAR = 0;
                int V_EVENT_CODE_ID = 0;
                int V_INSPECTION_STATUS = 0;

                V_INSPECTION_STATUS = m_InspectionStatus;
                try
                {

                    V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
                }
                catch
                {
                }
                V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);
                V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);

                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_INSPECTION_STATUS", V_INSPECTION_STATUS));
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VDM_INP_SELECT_WAINSPECTION, OledbParams, gdvOpenContractor);
                ViewState["dataTable"] = gdvOpenContractor.DataSource as DataSet;


                DataSet ds = gdvOpenContractor.DataSource as DataSet;
                DataView dv = new DataView();
                dv.Table = ds.Tables[0];
                dv.Sort = "inspection_due_date DESC";
                string str = dv.Table.Rows[0]["inspection_due_date"].ToString();
                if (str != "")
                {
                    txtDueDate.Text = String.Format("{0:MM-dd-yyyy}", Convert.ToDateTime(str)); 
                }

                gdvOpenContractor.SelectedIndex = -1;

                if (gdvOpenContractor.Rows.Count > 0)
                {
                    //btnSave.Visible = true;
                    btnExportExcel.Visible = true;
                }
                else
                {
                    // btnSave.Visible = false;
                    btnExportExcel.Visible = false;
                }

                //checks user role
                if (gdvOpenContractor.Rows.Count > 0 && hdn_role.Value == "2")
                {
                    btnSave.Visible = true;
                }
                else if (gdvOpenContractor.Rows.Count > 0 && hdn_role.Value == "3")
                {
                    btnSave.Visible = true;
                }
                else if (gdvOpenContractor.Rows.Count > 0 && hdn_role.Value == "1")
                {
                    btnSave.Visible = false;
                }
                else if (hdn_role.Value == "0")
                {
                    Response.Redirect("Default.aspx");
                }
                //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
                //if (gdvOpenContractor.Rows.Count > 0 && userRole == "Edit")
                //{
                //    //rowDueDate.Visible = true;
                //    btnSave.Visible = true;
                //}
                //else
                //{
                //    //rowDueDate.Visible = false;
                //    btnSave.Visible = false;
                //}


                if (V_INSPECTION_STATUS == 5)
                {
                    ((Label)gdvOpenContractor.HeaderRow.Cells[3].Controls[3]).Text = "INSPECTION OPEN";
                }
                else
                {
                    ((Label)gdvOpenContractor.HeaderRow.Cells[3].Controls[3]).Text = "INSPECTION CLOSE";
                }
                //this.gdvOpenContractor.Columns[3].HeaderText = "The new header";
            }

            catch
            {
            }


        }
        protected void rbt_open_CheckedChanged(object sender, EventArgs e)
        {
            InspectionStatus();
            BindBusinessUnit();
            BindYear();

            txtDueDate.Text = "";
            rowDueDate.Visible = false;
            btnSave.Visible = false;
            btnExportExcel.Visible = false;
        }

        protected void rbt_close_CheckedChanged(object sender, EventArgs e)
        {
            InspectionStatus();
            BindBusinessUnit();
            BindYear();

            txtDueDate.Text = "";
            rowDueDate.Visible = false;
            btnSave.Visible = false;
            btnExportExcel.Visible = false;
        }

        protected void ddlBUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
           BindYear();
        }

        protected void ddlBUnit_DataBound(object sender, EventArgs e)
        {
           // BindYear();
        }

        protected void ddlYear_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindEventCode();
        }

        protected void ddlYear_DataBound(object sender, EventArgs e)
        {
            BindEventCode();
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindGrid();

            if (rbt_close.Checked)
            {
                txtDueDate.Text = "";
                rowDueDate.Visible = false;
            }

            if (ddlEventCode.SelectedValue == "-1" || ddlEventCode.SelectedValue == "0")
            {
                txtDueDate.Text = "";
                rowDueDate.Visible = false;
                btnSave.Visible = false;
            }

            if(ddlEventCode.SelectedValue != "-1" && ddlEventCode.SelectedValue != "0" && rbt_open.Checked)
            {
                //txtDueDate.Text = "";
                rowDueDate.Visible = true;
                btnSave.Visible = true;
            }
        }

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            BindGrid();
        }

       

        protected void cbSelectAll_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox ChkBoxHeader = (CheckBox)gdvOpenContractor.HeaderRow.FindControl("cbSelectAll");
            foreach (GridViewRow row in gdvOpenContractor.Rows)
            {
                CheckBox ChkBoxRows = (CheckBox)row.FindControl("cbSelect");
                if (ChkBoxRows.Enabled == true)
                {
                    if (ChkBoxHeader.Checked == true)
                    {
                        ChkBoxRows.Checked = true;
                    }
                    else
                    {
                        ChkBoxRows.Checked = false;
                    }
                }
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            int retVal = 0;
            int V_WORK_AREA_ID;
            int V_WORK_STATUS_ID;
            int V_COMPANY_ID;
            string V_DUE_DATE=string.Empty;

            try
            {
                if (txtDueDate.Text.Trim() != "")
                {
                    V_DUE_DATE = txtDueDate.Text.Trim();
                }
                else
                {
                    V_DUE_DATE = DBNull.Value.ToString();
                }
            }
            catch { }

            foreach (GridViewRow row in gdvOpenContractor.Rows)
            {
                if (((CheckBox)row.FindControl("cbSelect")).Checked)
                {

                    if (txtDueDate.Text == "" && rbt_open.Checked)
                    {
                        ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Please Enter Due Date.')", true);
                        txtDueDate.Focus();
                        return;
                    }

                    V_WORK_AREA_ID = Convert.ToInt32(((Label)row.FindControl("lbl_WORK_AREA_ID")).Text);
                    if (m_InspectionStatus == 5)
                    {
                        V_WORK_STATUS_ID = 6;
                    }
                    else
                    {
                        V_WORK_STATUS_ID = 8;
                    }
                }

                else
                {
                    V_WORK_AREA_ID = Convert.ToInt32(((Label)row.FindControl("lbl_WORK_AREA_ID")).Text);
                    if (m_InspectionStatus == 5)
                    {
                        V_WORK_STATUS_ID = 5;
                    }
                    else
                    {
                        V_WORK_STATUS_ID = 6;
                    }
                }

                V_COMPANY_ID = Convert.ToInt32(((Label)row.FindControl("lbl_COMPANY_ID")).Text);
                try
                {
                    List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                    //sqlParams.Add(new OleDbParameter("V_COMPANY_ID", V_COMPANY_ID));
                    sqlParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                    sqlParams.Add(new OleDbParameter("V_WORK_STATUS_ID", V_WORK_STATUS_ID));
                    sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                    sqlParams.Add(new OleDbParameter("V_DUE_DATE", V_DUE_DATE));
                    retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_INP_UPDATE_INSP_STATUS, sqlParams);
                }
                catch
                {
                }
            }

            if (retVal == 1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Update successful')", true);
                txtDueDate.Text = "";
            }
            BindGrid();
        }

        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddlBUnit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddlYear.SelectedItem.Text);
                dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
                List<int> listHideColumns = new List<int>(new int[] { 4 });
                VDMUtil.ExportGridToExcel(gdvOpenContractor, "Open/Close for Inspection", "InspectionOPenClose", dictionaryFilters, null);
            }
            catch
            {
            }
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }
    }
}