﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;
using System.IO;

namespace VMT
{
    public partial class MapPrinting : System.Web.UI.Page
    {
        string m_SP_MP_SELECT_BU = Properties.Settings.Default.SP_MP_SELECT_BU;
        string m_SP_MP_SELECT_YR = Properties.Settings.Default.SP_MP_SELECT_YR;
        string m_SP_MP_SELECT_MAP_PRINTING = Properties.Settings.Default.SP_MP_SELECT_MAP_PRINTING;

        protected void Page_Load(object sender, EventArgs e)
        {
            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            if (!Page.IsPostBack)
            {
                BindBusinessUnit();
                ddlBunit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
            }
        }

        void BindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_MP_SELECT_BU, ddlBunit);
            }
            catch
            {
            }
        }

        void BindYear()
        {
            int V_BUSINESS_UNIT_ID = 0;
            try
            {
                V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBunit.SelectedValue);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_MP_SELECT_YR, OledbParams, ddlCycleYear);
            }
            catch
            {
            }
        }

        void BindGrid()
        {
            if (ddlOption.SelectedIndex != 0)
            {
                int V_BUSINESS_UNIT_ID = 0;
                int V_YEAR_ID = 0;
                string V_GROUP_BY = "";
                try
                {
                    V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBunit.SelectedValue);
                    V_YEAR_ID = Convert.ToInt32(ddlCycleYear.SelectedValue);
                    V_GROUP_BY = ddlOption.SelectedValue;

                    List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                    OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                    OledbParams.Add(new OleDbParameter("V_YEAR_ID", V_YEAR_ID));
                    OledbParams.Add(new OleDbParameter("V_GROUP_BY", V_GROUP_BY));
                    DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_MP_SELECT_MAP_PRINTING, OledbParams, gdvMapPrinting);

                    ViewState["dataTable"] = gdvMapPrinting.DataSource as DataSet;
                    gdvMapPrinting.SelectedIndex = -1;
                   
                }
                catch
                {
                }
            }
            else
                gdvMapPrinting.DataBind();
            if (gdvMapPrinting.Rows.Count > 0)
                btnExportExcel.Visible = true;
            else
                btnExportExcel.Visible = false;
        }

        protected void ddlBunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindYear();
            ddlOption.SelectedIndex = 0;
            BindGrid();
        }

        protected void ddlBunit_DataBound(object sender, EventArgs e)
        {
            BindYear();
            ddlOption.SelectedIndex = 0;
            BindGrid();
        }

        protected void ddlCycleYear_DataBound(object sender, EventArgs e)
        {
            ddlOption.SelectedIndex = 0;
            BindGrid();
        }

        protected void ddlCycleYear_SelectedIndexChanged(object sender, EventArgs e)
        {
            ddlOption.SelectedIndex = 0;
            BindGrid();
        }

        protected void ddlOption_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindGrid();
        }

        protected void ddlOption_DataBound(object sender, EventArgs e)
        {
            BindGrid();
        }

        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            gdvMapPrinting.ShowHeader = true;
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddlBunit.SelectedItem.Text);
                dictionaryFilters.Add("Cycle Year", ddlCycleYear.SelectedItem.Text);
                dictionaryFilters.Add("Group By", ddlOption.SelectedItem.Text);
                List<int> listHideColumns = new List<int>(new int[] {});
                VDMUtil.ExportGridToExcel(gdvMapPrinting, "Map Printing", "Map_Printing", dictionaryFilters, listHideColumns);
            }
            catch
            {
            }
        }

        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }


        //private string _sortDirection;
        protected void gdvMapPrinting_Sorting(object sender, GridViewSortEventArgs e)
        {
            try
            {
                VDMUtil.GridviewSorting(gdvMapPrinting, e.SortExpression, (DataSet)ViewState["dataTable"]);
            }
            catch
            {
            }
        }
      

        
        
        
    }
}