﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;

namespace VMT
{
    public partial class LocateWAHist_Map : System.Web.UI.Page
    {
        string m_SP_SPR_MAP_GET_WA_EVCODE_DESC = Properties.Settings.Default.SP_SPR_MAP_GET_WA_EVCODE_DESC;

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                

                if (String.IsNullOrEmpty(Request.QueryString["WORK_AREA_ID"]))
                {
                    lblWa.Visible = false;
                    lblWaValue.Visible = false;
                    return;
                }
                else
                {
                    lblWa.Visible = true;
                    lblWaValue.Visible = true;
                    int V_WORK_AREA_ID = Convert.ToInt16(Request.QueryString["WORK_AREA_ID"].ToString());
                    GetEventCodeDesc(V_WORK_AREA_ID);
                }
            }
        }

        private void GetEventCodeDesc(int V_WORK_AREA_ID)
        {
            DataSet ds = new DataSet();
            List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
            OleDbParams.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));

            ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_SPR_MAP_GET_WA_EVCODE_DESC, OleDbParams);
            if (ds.Tables[0].Rows.Count > 0)
            {
                hdnEventCode.Value = ds.Tables[0].Rows[0][0].ToString();
                hdnWworkArea.Value = ds.Tables[0].Rows[0][1].ToString();
            }
        }

    }
}