﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Data.SqlClient;
using DataAccess;
using System.IO;

namespace VMT
{
    public partial class InspectionJobView : System.Web.UI.Page
    {
        string m_SP_SS_GET_ALL_INSPECTION_WA = Properties.Settings.Default.SP_SS_GET_ALL_INSPECTION_WA;
        
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Inspection View";

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                
                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

            }
            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            //if (userRole == "Edit")
            //{
            //    btnSubmitBid.Visible = true;
            //}
            //else
            //{
            //    btnSubmitBid.Visible = false;
            //}
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            BindInspectionJobs();
        }


        private void BindInspectionJobs()
        {
            try
            {

                DataAccessUtility.BindGridViewViaProcedure(m_SP_SS_GET_ALL_INSPECTION_WA, gdvBidProcess);
                ViewState["dataTable"] = gdvBidProcess.DataSource as DataSet;
                gdvBidProcess.SelectedIndex = -1;
                if (gdvBidProcess.Rows.Count > 0)
                    btnExportExcel.Visible = true;
                else
                    btnExportExcel.Visible = false;
            }
            catch
            {
            }
        }
        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }
             
        protected void gdvBidProcess_Sorting(object sender, GridViewSortEventArgs e)
        {
            try
            {
                VDMUtil.GridviewSorting(gdvBidProcess, e.SortExpression, (DataSet)ViewState["dataTable"]);
            }
            catch
            {
            }
        }

        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                
                List<int> listHideColumns = new List<int>(new int[] { 4 });
                VDMUtil.ExportGridToExcel(gdvBidProcess, "Inspection Assigned Job View", "Inspection_Jobs", dictionaryFilters, listHideColumns);
            }
            catch
            {
            }
        }

    }
}