﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.SqlClient;

namespace VMT
{
    public partial class InspectionIsuueTypes : System.Web.UI.Page
    {
        string m_SP_IST_SEL_ISSUE_TYPES = Properties.Settings.Default.SP_IST_SEL_ISSUE_TYPES;
        string m_SP_IST_ISSUE_TYPE_INS_UPD = Properties.Settings.Default.SP_IST_ISSUE_TYPE_INS_UPD;
        string m_SP_IST_ISSUE_TYPE_DETAIL = Properties.Settings.Default.SP_IST_ISSUE_TYPE_DETAIL;
        string m_SP_IST_SEL_ISSUE_GROUP = Properties.Settings.Default.SP_IST_SEL_ISSUE_GROUP;
        string m_SP_IST_SEL_ISSUE_SUBGROUP = Properties.Settings.Default.SP_IST_SEL_ISSUE_SUBGROUP;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Inspection Issue Types";

        protected void Page_Load(object sender, EventArgs e)
        {
            

            //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
            //if (userRole == "Edit")
            //{
            //    btn_add.Visible = true;
            //}
            //else
            //{
            //    btn_add.Visible = false;
            //}

            if (!Page.IsPostBack)
            {

                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                BindGrid();
                BindIssueGroup();
                BindIssueSubGroup();
                btn_create.Visible = false;
                btn_delete.Visible = false;

            }
        }
        void BindIssueGroup()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_IST_SEL_ISSUE_GROUP, ddlIssueGroup);
            }
            catch
            {
            }
        }

        void BindIssueSubGroup()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_issue_group", ddlIssueGroup.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_IST_SEL_ISSUE_SUBGROUP,OledbParams, ddlIssueSubGroup);
            }
            catch
            {
            }
        }

        protected void ddlIssueGroup_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindIssueSubGroup();
        }

        protected void ddlIssueGroup_DataBound(object sender, EventArgs e)
        {
            BindIssueSubGroup();
        }

        private void BindGrid()
        {
            try
            {
                DataAccessUtility.BindGridViewViaProcedure(m_SP_IST_SEL_ISSUE_TYPES, gdv_list);
                gdv_list.SelectedIndex = -1;
            }
            catch
            {
            }
        }
        protected void btn_add_Click(object sender, EventArgs e)
        {
            if (btn_add.Text == "Add New")
            {
                AddUpdate("INSERT");
            }
            else if (btn_add.Text == "Update")
            {
                AddUpdate("UPDATE");
            }
        }

        private void AddUpdate(string strOperation)
        {
            if (txtIssueType.Text.Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Issue type could not be blank!')", true);
                txtIssueType.Focus();
                return;
            }
            int ISSUE_ID = 0;
            if (strOperation == "INSERT")
            {
                ISSUE_ID = 0;
            }
            else
            {
                ISSUE_ID = Int32.Parse(hdn_keyid.Value);
            }

            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_IST_ISSUE_ID", ISSUE_ID));
                sqlParams.Add(new OleDbParameter("V_IST_ISSUE_TYPE", txtIssueType.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_IST_ISSUE_GROUP", ddlIssueGroup.SelectedValue));
                sqlParams.Add(new OleDbParameter("V_IST_ISSUE_SUBGROUP", ddlIssueSubGroup.SelectedValue));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_IST_ISSUE_TYPE_INS_UPD, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                BindGrid();
                clearfields();
                BindIssueSubGroup();
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Issue type already exists')", true);
            }

        }

        protected void gdv_list_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
        {
            GridViewRow row = gdv_list.Rows[e.NewSelectedIndex];
            hdn_keyid.Value = row.Cells[1].Text;

            //if (userRole == "3")
            //{
                btn_add.Text = "Update";
                btn_create.Visible = true;
                btn_delete.Visible = true;
            //}
            getdetail();
        }
        void getdetail()
        {
            DataSet ds = new DataSet();
            List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
            try
            {
                OleDbParams.Add(new OleDbParameter("V_ISSUE_ID", hdn_keyid.Value));

                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_IST_ISSUE_TYPE_DETAIL, OleDbParams);


                //bind the fields 
                txtIssueType.Text = ds.Tables[0].Rows[0]["ISSUE_TYPE"].ToString();
                ddlIssueGroup.SelectedValue = ds.Tables[0].Rows[0]["ISSUE_GROUP"].ToString();
                BindIssueSubGroup();
                ddlIssueSubGroup.SelectedValue = ds.Tables[0].Rows[0]["ISSUE_SUBGROUP"].ToString();
            }
            catch
            {
            }
            finally
            {
                ds.Clear();
                ds.Dispose();
            }
        }
        void clearfields()
        {
            btn_create.Visible = false;
            btn_delete.Visible = false;
            hdn_keyid.Value = "";
            btn_add.Text = "Add New";
            txtIssueType.Text = "";
            //BindIssueGroup();

        }

        protected void btn_reset_Click(object sender, EventArgs e)
        {
            if (hdn_keyid.Value == "")
            {
                clearfields();
            }

            else
            {
                getdetail();
            }
        }

        protected void btn_delete_Click(object sender, EventArgs e)
        {
            AddUpdate("DELETE");
        }

        protected void btn_create_Click(object sender, EventArgs e)
        {
            clearfields();
        }

        protected void gdv_list_RowCreated(object sender, GridViewRowEventArgs e)
        {
            e.Row.Cells[1].Visible = false; // hides the first column
        }
    }
}