﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;
using System.Data.OracleClient;
using System.Globalization;

namespace VMT
{
    public partial class ForecastAnalysis : System.Web.UI.Page
    {
        string m_SP_VDM_SELECT_BSUNIT_FORECAST = Properties.Settings.Default.SP_VDM_SELECT_BSUNIT_FORECAST;
        string m_SP_VDM_SELECT_YEAR_SANDBOX = Properties.Settings.Default.SP_FA_SELECT_YEAR_SANDBOX;
        string m_SP_FA_SELECT_SANDBOX_NAMES = Properties.Settings.Default.SP_FA_SELECT_SANDBOX_NAMES;
        string m_SP_FA_SELECT_SANDBOX_VMTUSERS = Properties.Settings.Default.SP_FA_SELECT_SANDBOX_VMTUSERS;
        string m_SP_VDM_SELECT_BU_YEAR_FORECAST = Properties.Settings.Default.SP_VDM_SELECT_BU_YEAR_FORECAST;
        string m_SP_FA_SELECT_FORECAST_ANALYSIS = Properties.Settings.Default.SP_FA_SELECT_FORECAST_ANALYSIS;
        string m_SP_VDM_SELECT_COMP_RATE_ASSN = Properties.Settings.Default.SP_VDM_SELECT_COMP_RATE_ASSN;
        string m_SP_FA_SELECT_DEFAULT_RATE = Properties.Settings.Default.SP_FA_SELECT_DEFAULT_RATE;
        string m_SP_FA_SANDBOX_HEADER_INS = Properties.Settings.Default.SP_FA_SANDBOX_HEADER_INS;
        string m_SP_FA_SANDBOX_DETAIL_INS = Properties.Settings.Default.SP_FA_SANDBOX_DETAIL_INS;
        string m_SP_FA_SELECT_SANDBOX_DETAIL = Properties.Settings.Default.SP_FA_SELECT_SANDBOX_DETAIL;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Planning";
        string userRole = string.Empty;

        protected void Page_Unload(object sender, EventArgs e)
        {           
            ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('unload!')", true);
        }

        protected void Page_Load(object sender, EventArgs e)
        {
           
            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            lblVmtUser.Text= System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper();
            if (!Page.IsPostBack)
            {

                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }
                hdn_role.Value = userRole;

                bindBusinessUnit();
                //ValidateScegRates();  
                ddl_Bunit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                bindYear();
                ViewState["SortDireaction"] = "ASC";
            }
        }
       
        
        void bindYear()
        {
            int V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue); 
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_YEAR_SANDBOX, OledbParams, ddl_Year);
            }
            catch
            {
            }
        }

        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_BSUNIT_FORECAST, ddl_Bunit);
            }
            catch
            {
            }
        }

        protected void ddl_Bunit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindYear();
        }

        //protected void ddl_Bunit_DataBound(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        bindYear();
        //        //ddl_Year.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
        //    }
        //    catch
        //    {
        //    }
        //}

        
        

        private void bindGrid()
        {
           
                int V_BUSINESS_UNIT_ID = 0;
                int V_YEAR = 0;
                try
                {
                    V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                    V_YEAR = Convert.ToInt32(ddl_Year.SelectedValue);
                    List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                    OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                    OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));

                    DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_FA_SELECT_FORECAST_ANALYSIS, OledbParams, gdv_Forescast_Analysis);
                    
                     ViewState["dsForecastAnls"] = gdv_Forescast_Analysis.DataSource as DataSet;

                     BindSummaryGrid();
                }
                catch
                {
                }

                if (gdv_Forescast_Analysis.Rows.Count > 0)
                {
                    gdv_Forescast_Analysis.SelectedIndex = -1;
                    btnExportExcel.Visible = true;
                    btnSubmitSandBox.Enabled = true;
                    btnPostSandBox.Enabled = true;
                    divCreateSandBox.Visible = true;
                }

                else
                {
                    btnExportExcel.Visible = false;
                    btnSubmitSandBox.Enabled = false;
                    btnPostSandBox.Enabled = true;
                    divCreateSandBox.Visible = false;
                }
                //ScriptManager.RegisterStartupScript(Page, this.GetType(), "Key", "<script>MakeStaticHeader('" + gdv_Forescast_Analysis.ClientID + "', 400, 950 , 40 ,true); </script>", false);
            }

        protected void gdv_Forescast_Analysis_RowDataBound(object sender, GridViewRowEventArgs e)
        {

            try
            {
                for (int i = 0; i < e.Row.Cells.Count; i++)
                {
                    e.Row.Cells[i].Attributes.Add("style", "white-space: nowrap;");

                }
                if (e.Row.RowType == DataControlRowType.Header)
                {
                    int index;
                    foreach (TableCell tc in (e.Row.Cells))
                    {
                        index = (e.Row.Cells.GetCellIndex(tc));
                        LinkButton objHeader = new LinkButton();
                        objHeader.Text = e.Row.Cells[index].Text;
                        //e.Row.Cells[index].Controls.Clear();               
                        e.Row.Cells[index].Controls.Add(objHeader);
                        e.Row.Cells[index].ForeColor = System.Drawing.Color.Black;
                    }

                }

                if (e.Row.RowType == DataControlRowType.DataRow)
                {
                    DataSet ds = gdv_Forescast_Analysis.DataSource as DataSet;
                    DataView dv = new DataView(ds.Tables[0]);
                    DataTable dt = dv.ToTable();
                    

                    Label lblSCEG_forecast = ((Label)e.Row.FindControl("lblSCEG_forecast"));
                    TextBox txtBID_TOTAL = ((TextBox)e.Row.FindControl("txtBID_TOTAL"));
                    Label lblNEW_Bid = ((Label)e.Row.FindControl("lblNEW_Bid"));
                    Label lblVARIANCE = ((Label)e.Row.FindControl("lblVARIANCE"));
                    Label lblCOMPANY = ((Label)e.Row.FindControl("lblCOMPANY"));
                    Label lblSTATUS = ((Label)e.Row.FindControl("lblSTATUS"));

                    DropDownList ddlCompany = (DropDownList)e.Row.FindControl("ddlCompany");
                    TextBox txtFLAT_RATE = ((TextBox)e.Row.FindControl("txtFLAT_RATE"));
                    TextBox txtURBAN_RATE = ((TextBox)e.Row.FindControl("txtURBAN_RATE"));
                    TextBox txtRURAL_RATE = ((TextBox)e.Row.FindControl("txtRURAL_RATE"));
                    TextBox txtCLIMBING_RATE = ((TextBox)e.Row.FindControl("txtCLIMBING_RATE"));
                    CheckBox chk3Unit = ((CheckBox)e.Row.FindControl("chk3Unit"));

                    if (lblSTATUS.Text == "P")
                    {
                        ddlCompany.Enabled = false;
                        chk3Unit.Enabled = false;
                        txtFLAT_RATE.Enabled = false;
                        txtURBAN_RATE.Enabled = false;
                        txtRURAL_RATE.Enabled = false;
                        txtCLIMBING_RATE.Enabled = false;
                        txtBID_TOTAL.Enabled = false;
                    }
                    else
                    {ddlCompany.Enabled = true;}

                    double climbing = Convert.ToDouble(((Label)e.Row.FindControl("lblCLIMBING")).Text.Trim());
                    double rural = Convert.ToDouble(((Label)e.Row.FindControl("lblRURAL")).Text.Trim());
                    double urban = Convert.ToDouble(((Label)e.Row.FindControl("lblURBAN")).Text.Trim());

                    if ((txtUrbanRate.Text.Length > 0) || (txtRuralRate.Text.Length > 0) || (txtClimbRate.Text.Length > 0))
                    {
                        double SCEG_forecast = (Convert.ToDouble(txtUrbanRate.Text.Trim()) * urban) +
                            (Convert.ToDouble(txtRuralRate.Text.Trim()) * rural) + (Convert.ToDouble(txtClimbRate.Text.Trim()) * climbing);
                        ds.Tables[0].Rows[e.Row.RowIndex]["SCEG_forecast"] = lblSCEG_forecast.Text = Convert.ToDouble(SCEG_forecast).ToString("#,##0.00");
                        ds.Tables[0].Rows[e.Row.RowIndex]["VARIANCE"] = lblVARIANCE.Text = (Convert.ToDouble(txtBID_TOTAL.Text.Trim()) - Convert.ToDouble(lblSCEG_forecast.Text.ToString())).ToString("#,##0.00");

                    }
                    DataSet ds1 = null;
                    if (ddlCompany != null)
                    {

                        DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_COMP_RATE_ASSN, ddlCompany);
                        if((e.Row.FindControl("lblCOMPANY") as Label).Text == "")                        
                        {
                            chk3Unit.Enabled = false;
                            txtFLAT_RATE.Enabled = false;
                            txtURBAN_RATE.Enabled = false;
                            txtRURAL_RATE.Enabled = false;
                            txtCLIMBING_RATE.Enabled = false;
                            //txtBID_TOTAL.Enabled = false;                           
                        }
                        else
                        {
                            ddlCompany.Items.FindByText((e.Row.FindControl("lblCOMPANY") as Label).Text).Selected = true;
                            ds1 = BindRate(Convert.ToInt32(ddlCompany.SelectedValue));

                            chk3Unit.Enabled = true;
                            if (chk3Unit.Checked)
                            {
                                txtFLAT_RATE.Enabled = false;
                                txtURBAN_RATE.Enabled = true;
                                txtRURAL_RATE.Enabled = true;
                                txtCLIMBING_RATE.Enabled = true;
                            }
                            else
                            {
                                txtFLAT_RATE.Enabled = true;
                                txtURBAN_RATE.Enabled = false;
                                txtRURAL_RATE.Enabled = false;
                                txtCLIMBING_RATE.Enabled = false;

                            }

                        }
                        //if (!radBtnView.Checked && lblCOMPANY.Text != "- Select -") chk3Unit.Enabled = true;
                        //ds.Tables[0].Rows[e.Row.RowIndex]["company"] = ddlCompany.SelectedItem.Text;

                        if (ddlCompany.SelectedIndex != 0)
                        {
                            if (ds1.Tables[0].Rows.Count > 0)
                            {
                                if (chk3Unit.Checked)
                                {
                                    ds.Tables[0].Rows[e.Row.RowIndex]["URBAN_RATE"] = txtURBAN_RATE.Text = ds1.Tables[0].Rows[0]["URBAN_RATE"].ToString() == "" ? "0" : Convert.ToDouble(ds1.Tables[0].Rows[0]["URBAN_RATE"].ToString()).ToString("#,##0.00"); ;
                                    ds.Tables[0].Rows[e.Row.RowIndex]["RURAL_RATE"] = txtRURAL_RATE.Text = ds1.Tables[0].Rows[0]["RURAL_RATE"].ToString() == "" ? "0" : Convert.ToDouble(ds1.Tables[0].Rows[0]["RURAL_RATE"].ToString()).ToString("#,##0.00"); ;
                                    ds.Tables[0].Rows[e.Row.RowIndex]["CLIMBING_RATE"] = txtCLIMBING_RATE.Text = ds1.Tables[0].Rows[0]["CLIMBING_RATE"].ToString() == "" ? "0" : Convert.ToDouble(ds1.Tables[0].Rows[0]["CLIMBING_RATE"].ToString()).ToString("#,##0.00"); ;
                           
                                }
                                else 
                                    ds.Tables[0].Rows[e.Row.RowIndex]["FLAT_RATE"] = txtFLAT_RATE.Text = ds1.Tables[0].Rows[0]["FLAT_RATE"].ToString() == "" ? "0" : Convert.ToDouble(ds1.Tables[0].Rows[0]["FLAT_RATE"].ToString()).ToString("#,##0.00");
                            }


                            if (txtFLAT_RATE.Text.Length > 0)
                            {
                                double FLAT_RATE = Convert.ToDouble(txtFLAT_RATE.Text.Trim());
                                double totMiles = Convert.ToDouble(((Label)e.Row.FindControl("lblTOTAL_MILES")).Text.Trim());
                                double totBid = FLAT_RATE * totMiles;
                                ds.Tables[0].Rows[e.Row.RowIndex]["BID_TOTAL"] = txtBID_TOTAL.Text = totBid.ToString("#,##0.00");
                                ds.Tables[0].Rows[e.Row.RowIndex]["NEW_Bid"] = lblNEW_Bid.Text = totBid.ToString("#,##0.00");
                            }
                        }
                        else
                        {
                            chk3Unit.Enabled = false;
                        }
                    }

                    dt.AcceptChanges();
                    ViewState["dsForecastAnls"] = ds;
                }
                
            }
            catch
            {
            }

        }


        protected void ddlCompany_SelectedIndexChanged(object sender, EventArgs e)
        {
            GridViewRow gvRow = (GridViewRow)(sender as Control).Parent.Parent;
            int index = gvRow.RowIndex;
            DataSet ds = (DataSet)ViewState["dsForecastAnls"];
            DataView dv = new DataView(ds.Tables[0]);
            DataTable dt = dv.ToTable();

            DropDownList ddlCompany = ((DropDownList)gdv_Forescast_Analysis.Rows[index].FindControl("ddlCompany"));
            TextBox txtFLAT_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE"));
            TextBox txtURBAN_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtURBAN_RATE"));
            TextBox txtRURAL_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtRURAL_RATE"));
            TextBox txtCLIMBING_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtCLIMBING_RATE"));
            TextBox txtBID_TOTAL = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL"));
            Label lblNEW_Bid = ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblNEW_Bid"));
            CheckBox chk3Unit = ((CheckBox)gdv_Forescast_Analysis.Rows[index].FindControl("chk3Unit"));

            if (Convert.ToInt32(ddlCompany.SelectedValue) == 0)
            {
                //ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select a company')", true);
                chk3Unit.Checked = false;
                chk3Unit.Enabled = false;

                ds.Tables[0].Rows[index]["FLAT_RATE"] = txtFLAT_RATE.Text = "0";
                ds.Tables[0].Rows[index]["URBAN_RATE"] = txtURBAN_RATE.Text = "0";
                ds.Tables[0].Rows[index]["RURAL_RATE"] = txtRURAL_RATE.Text = "0";
                ds.Tables[0].Rows[index]["CLIMBING_RATE"] = txtCLIMBING_RATE.Text = "0";
                ds.Tables[0].Rows[index]["BID_TOTAL"] = txtBID_TOTAL.Text = "0";
                ds.Tables[0].Rows[index]["NEW_Bid"] = lblNEW_Bid.Text = "0";
                ds.Tables[0].Rows[index]["company"] = ddlCompany.SelectedItem.Text;

                dt.AcceptChanges();
                ViewState["dsForecastAnls"] = ds;
                //txtBID_TOTAL.Focus();
                BindSummaryGrid();
            }

            else
            {
                chk3Unit.Enabled = true;
                DataSet ds1 = BindRate(Convert.ToInt32(ddlCompany.SelectedValue));

                if (ds1.Tables[0].Rows.Count > 0)
                {
                    txtFLAT_RATE.Text = ds1.Tables[0].Rows[0]["FLAT_RATE"].ToString() == "" ? "0" : Convert.ToDouble(ds1.Tables[0].Rows[0]["FLAT_RATE"]).ToString("#,##0.00");

                    ViewState["txtURBAN_RATE"] = ds1.Tables[0].Rows[0]["URBAN_RATE"].ToString() == "" ? "0" : Convert.ToDouble(ds1.Tables[0].Rows[0]["URBAN_RATE"].ToString()).ToString("#,##0.00");
                    ViewState["txtRURAL_RATE"] = ds1.Tables[0].Rows[0]["RURAL_RATE"].ToString() == "" ? "0" : Convert.ToDouble(ds1.Tables[0].Rows[0]["RURAL_RATE"].ToString()).ToString("#,##0.00");
                    ViewState["txtCLIMBING_RATE"] =  ds1.Tables[0].Rows[0]["CLIMBING_RATE"].ToString() == "" ? "0" : Convert.ToDouble(ds1.Tables[0].Rows[0]["CLIMBING_RATE"].ToString()).ToString("#,##0.00");

                    ds.Tables[0].Rows[index]["URBAN_RATE"] = txtURBAN_RATE.Text = "0";
                    ds.Tables[0].Rows[index]["RURAL_RATE"] = txtRURAL_RATE.Text = "0";
                    ds.Tables[0].Rows[index]["CLIMBING_RATE"] = txtCLIMBING_RATE.Text = "0";

                    //txtURBAN_RATE.Text = ds1.Tables[0].Rows[0]["URBAN_RATE"].ToString() == "" ? "0" : Convert.ToDouble(ds1.Tables[0].Rows[0]["URBAN_RATE"]).ToString("#,##0.00");
                    //txtRURAL_RATE.Text = ds1.Tables[0].Rows[0]["RURAL_RATE"].ToString() == "" ? "0" : Convert.ToDouble(ds1.Tables[0].Rows[0]["RURAL_RATE"]).ToString("#,##0.00");
                    //txtCLIMBING_RATE.Text = ds1.Tables[0].Rows[0]["CLIMBING_RATE"].ToString() == "" ? "0" : Convert.ToDouble(ds1.Tables[0].Rows[0]["CLIMBING_RATE"]).ToString("#,##0.00");
                    
                    txtFLAT_RATE.Enabled = true;
                    dt.AcceptChanges();
                    ViewState["dsForecastAnls"] = ds;
                    //txtBID_TOTAL.Focus();
                    BindSummaryGrid();
                }


                if (chk3Unit.Checked)
                {
                    double climbing = Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblCLIMBING")).Text.Trim());
                    double rural = Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblRURAL")).Text.Trim());
                    double urban = Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblURBAN")).Text.Trim());

                    if ((txtURBAN_RATE.Text.Length > 0) || (txtRURAL_RATE.Text.Length > 0) || (txtCLIMBING_RATE.Text.Length > 0))
                    {
                        double totBid = (Convert.ToDouble(txtURBAN_RATE.Text.Trim()) * urban) +
                            (Convert.ToDouble(txtRURAL_RATE.Text.Trim()) * rural) + (Convert.ToDouble(txtCLIMBING_RATE.Text.Trim()) * climbing);
                        txtBID_TOTAL.Text = totBid.ToString("#,##0.00");
                        lblNEW_Bid.Text = totBid.ToString("#,##0.00");

                        ds.Tables[0].Rows[index]["FLAT_RATE"] = Convert.ToDouble(txtFLAT_RATE.Text.ToString()).ToString("#,##0.00");
                        ds.Tables[0].Rows[index]["URBAN_RATE"] = Convert.ToDouble(txtURBAN_RATE.Text.ToString()).ToString("#,##0.00");
                        ds.Tables[0].Rows[index]["RURAL_RATE"] = Convert.ToDouble(txtRURAL_RATE.Text.ToString()).ToString("#,##0.00");
                        ds.Tables[0].Rows[index]["CLIMBING_RATE"] = Convert.ToDouble(txtCLIMBING_RATE.Text.ToString()).ToString("#,##0.00");
                        ds.Tables[0].Rows[index]["BID_TOTAL"] = Convert.ToDouble(txtBID_TOTAL.Text.ToString()).ToString("#,##0.00");
                        ds.Tables[0].Rows[index]["NEW_Bid"] = Convert.ToDouble(lblNEW_Bid.Text.ToString()).ToString("#,##0.00");
                        ds.Tables[0].Rows[index]["company"] = ddlCompany.SelectedItem.Text;

                        dt.AcceptChanges();
                        ViewState["dsForecastAnls"] = ds;
                        //txtBID_TOTAL.Focus();
                        BindSummaryGrid();
                    }
                }

                else
                {
                    Label lblVARIANCE = ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblVARIANCE"));
                    TextBox txtTotBid = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL"));

                    if (txtFLAT_RATE.Text.Trim().Length > 0) //|| txtFLAT_RATE.Text.Trim() != "0"
                    {
                        if (!ValidateControls(txtFLAT_RATE))
                        {

                            txtTotBid.Text = "0";
                            lblNEW_Bid.Text = "0";
                            lblVARIANCE.Text = (0 - Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblSCEG_forecast")).Text.Trim())).ToString("#,##0.00");
                        }
                        else
                        {
                            double rate = Convert.ToDouble(((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE")).Text.Trim());
                            double totMiles = Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblTOTAL_MILES")).Text.Trim());
                            double totBid = rate * totMiles;

                            txtTotBid.Text = totBid.ToString("#,##0.00");
                            lblNEW_Bid.Text = totBid.ToString("#,##0.00");
                            ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblVARIANCE")).Text = (totBid -
                                Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblSCEG_forecast")).Text.Trim())).ToString("#,##0.00");
                        }
                        ds.Tables[0].Rows[index]["FLAT_RATE"] = txtFLAT_RATE.Text = Convert.ToDouble(txtFLAT_RATE.Text.Trim()).ToString("#,##0.00");
                        ds.Tables[0].Rows[index]["BID_TOTAL"] = txtTotBid.Text;
                        ds.Tables[0].Rows[index]["NEW_Bid"] = lblNEW_Bid.Text;
                        ds.Tables[0].Rows[index]["VARIANCE"] = lblVARIANCE.Text = Convert.ToDouble(lblVARIANCE.Text.Trim()).ToString("#,##0.00");
                        ds.Tables[0].Rows[index]["company"] = ddlCompany.SelectedItem.Text;

                        dt.AcceptChanges();
                        ViewState["dsForecastAnls"] = ds;
                        //txtBID_TOTAL.Focus();
                        BindSummaryGrid();
                    }

                    else
                    {
                        ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate can not be blank!')", true);
                        ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE")).Focus();
                        return;
                    }
                }

            }
        }

        protected void chk3Unit_CheckedChanged(object sender, EventArgs e)
        {

            GridViewRow gvRow = (GridViewRow)(sender as Control).Parent.Parent;
            int index = gvRow.RowIndex;
            DataSet ds = (DataSet)ViewState["dsForecastAnls"];
            DataView dv = new DataView(ds.Tables[0]);
            DataTable dt = dv.ToTable();

            TextBox txtFLAT_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE"));
            TextBox txtURBAN_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtURBAN_RATE"));
            TextBox txtRURAL_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtRURAL_RATE"));
            TextBox txtCLIMBING_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtCLIMBING_RATE"));
            TextBox txtBID_TOTAL = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL"));
            Label lblNEW_Bid = ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblNEW_Bid"));
            CheckBox chk3Unit = ((CheckBox)gdv_Forescast_Analysis.Rows[index].FindControl("chk3Unit"));
            DropDownList ddlCompany = ((DropDownList)gdv_Forescast_Analysis.Rows[index].FindControl("ddlCompany"));

            if (chk3Unit.Checked)
            {

                txtFLAT_RATE.Enabled = false;
                ViewState["txtFLAT_RATE"]=txtFLAT_RATE.Text.Trim();
                txtFLAT_RATE.Text = "0";
                txtURBAN_RATE.Enabled = true;
                txtRURAL_RATE.Enabled = true;
                txtCLIMBING_RATE.Enabled = true;
                txtURBAN_RATE.Text = ViewState["txtURBAN_RATE"].ToString();
                txtRURAL_RATE.Text = ViewState["txtRURAL_RATE"].ToString();
                txtCLIMBING_RATE.Text = ViewState["txtCLIMBING_RATE"].ToString();

                double climbing = Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblCLIMBING")).Text.Trim());
                double rural = Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblRURAL")).Text.Trim());
                double urban = Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblURBAN")).Text.Trim());

                if ((txtURBAN_RATE.Text.Length > 0) || (txtRURAL_RATE.Text.Length > 0) || (txtCLIMBING_RATE.Text.Length > 0))
                {
                    double totBid = (Convert.ToDouble(txtURBAN_RATE.Text.Trim()) * urban) +
                        (Convert.ToDouble(txtRURAL_RATE.Text.Trim()) * rural) + (Convert.ToDouble(txtCLIMBING_RATE.Text.Trim()) * climbing);
                    txtBID_TOTAL.Text = totBid.ToString("#,##0.00");
                    lblNEW_Bid.Text = totBid.ToString("#,##0.00");
                    

                    ds.Tables[0].Rows[index]["FLAT_RATE"] = Convert.ToDouble(txtFLAT_RATE.Text.ToString()).ToString("#,##0.00");
                    ds.Tables[0].Rows[index]["URBAN_RATE"] = Convert.ToDouble(txtURBAN_RATE.Text.ToString()).ToString("#,##0.00");
                    ds.Tables[0].Rows[index]["RURAL_RATE"] = Convert.ToDouble(txtRURAL_RATE.Text.ToString()).ToString("#,##0.00");
                    ds.Tables[0].Rows[index]["CLIMBING_RATE"] = Convert.ToDouble(txtCLIMBING_RATE.Text.ToString()).ToString("#,##0.00");
                    ds.Tables[0].Rows[index]["BID_TOTAL"] = Convert.ToDouble(txtBID_TOTAL.Text.ToString()).ToString("#,##0.00");
                    ds.Tables[0].Rows[index]["NEW_Bid"] = Convert.ToDouble(lblNEW_Bid.Text.ToString()).ToString("#,##0.00");
                    ds.Tables[0].Rows[index]["company"] = ddlCompany.SelectedItem.Text;

                    dt.AcceptChanges();
                    ViewState["dsForecastAnls"] = ds;
                    //txtBID_TOTAL.Focus();
                    BindSummaryGrid();
                }
            }
                else
                {
                    txtFLAT_RATE.Enabled = true;
                    txtFLAT_RATE.Text = ViewState["txtFLAT_RATE"].ToString();
                    txtURBAN_RATE.Enabled = false;
                    txtRURAL_RATE.Enabled = false;
                    txtCLIMBING_RATE.Enabled = false;
                    ViewState["txtURBAN_RATE"] = txtURBAN_RATE.Text.Trim();
                    ds.Tables[0].Rows[index]["URBAN_RATE"] = txtURBAN_RATE.Text = "0";
                    ViewState["txtRURAL_RATE"] = txtRURAL_RATE.Text.Trim();
                    ds.Tables[0].Rows[index]["RURAL_RATE"] = txtRURAL_RATE.Text = "0";
                    ViewState["txtCLIMBING_RATE"] = txtCLIMBING_RATE.Text.Trim();
                    ds.Tables[0].Rows[index]["CLIMBING_RATE"] = txtCLIMBING_RATE.Text = "0";
                 
                    Label lblVARIANCE = ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblVARIANCE"));
                    TextBox txtTotBid = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL"));

                    if (txtFLAT_RATE.Text.Trim().Length > 0)
                    {
                        if (!ValidateControls(txtFLAT_RATE))
                        {

                            txtTotBid.Text = "0";
                            lblNEW_Bid.Text = "0";
                            lblVARIANCE.Text = (0 - Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblSCEG_forecast")).Text.Trim())).ToString("#,##0.00");
                        }
                        else
                        {
                            double rate = Convert.ToDouble(((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE")).Text.Trim());
                            double totMiles = Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblTOTAL_MILES")).Text.Trim());
                            double totBid = rate * totMiles;

                            txtTotBid.Text = totBid.ToString("#,##0.00");
                            lblNEW_Bid.Text = totBid.ToString("#,##0.00");
                            ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblVARIANCE")).Text = (totBid -
                                Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblSCEG_forecast")).Text.Trim())).ToString("#,##0.00");
                        }
                        ds.Tables[0].Rows[index]["FLAT_RATE"] = txtFLAT_RATE.Text = Convert.ToDouble(txtFLAT_RATE.Text.Trim()).ToString("#,##0.00");
                        ds.Tables[0].Rows[index]["BID_TOTAL"] = txtTotBid.Text;
                        ds.Tables[0].Rows[index]["NEW_Bid"] = lblNEW_Bid.Text;
                        ds.Tables[0].Rows[index]["VARIANCE"] = lblVARIANCE.Text = Convert.ToDouble(lblVARIANCE.Text.Trim()).ToString("#,##0.00");
                        ds.Tables[0].Rows[index]["company"] = ddlCompany.SelectedItem.Text;

                        dt.AcceptChanges();
                        ViewState["dsForecastAnls"] = ds;                        
                        BindSummaryGrid();
                    }
                    else
                    {
                        ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate can not be blank!')", true);
                        ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE")).Focus();
                        return;
                    }


                }
            
        }

        protected void gdv_Forescast_Analysis_Sorting(object sender, GridViewSortEventArgs e)
        {
            try
            {
                VDMUtil.GridviewSorting(gdv_Forescast_Analysis, e.SortExpression, (DataSet)ViewState["dataTable"]);
            }
            catch
            {
            }
        }

        private void ExportGridToExcel()
        {
            try
            {
                Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
                dictionaryFilters.Add("Business Unit", ddl_Bunit.SelectedItem.Text);
                dictionaryFilters.Add("Year", ddl_Year.SelectedItem.Text);

                VDMUtil.ExportGridToExcel(gdv_Forescast_Analysis, "Forescast Analysis", "Forescast_Analysis", dictionaryFilters, null);
            }
            catch
            {
            }
        }

        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            ExportGridToExcel();
        }

        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }

        protected void txtFLAT_RATE_TextChanged(object sender, EventArgs e)
        {
            try
            {
                GridViewRow gvRow = (GridViewRow)(sender as Control).Parent.Parent;
                int index = gvRow.RowIndex;
                DataSet ds = (DataSet)ViewState["dsForecastAnls"];
                DataView dv = new DataView(ds.Tables[0]);
                DataTable dt = dv.ToTable();

                TextBox txtFLAT_RATE = (TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE");
                Label lblVARIANCE = ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblVARIANCE"));
                TextBox txtTotBid = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL"));
                Label lblNEW_Bid = ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblNEW_Bid"));
                DropDownList ddlCompany = ((DropDownList)gdv_Forescast_Analysis.Rows[index].FindControl("ddlCompany"));

                if (txtFLAT_RATE.Text.Trim().Length > 0)
                {
                    if (!ValidateControls(txtFLAT_RATE))
                    {

                        txtTotBid.Text = "0";
                        lblNEW_Bid.Text = "0";
                        lblVARIANCE.Text = (0 - Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblSCEG_forecast")).Text.Trim())).ToString("#,##0.00");
                    }
                    else
                    {
                        double rate = Convert.ToDouble(((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE")).Text.Trim());
                        double totMiles = Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblTOTAL_MILES")).Text.Trim());
                        double totBid = rate * totMiles;

                        txtTotBid.Text = totBid.ToString("#,##0.00");
                        lblNEW_Bid.Text = totBid.ToString("#,##0.00");
                        ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblVARIANCE")).Text = (totBid -
                            Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblSCEG_forecast")).Text.Trim())).ToString("#,##0.00");
                    }
                    ds.Tables[0].Rows[index]["FLAT_RATE"] = txtFLAT_RATE.Text = Convert.ToDouble(txtFLAT_RATE.Text.Trim()).ToString("#,##0.00");
                    ds.Tables[0].Rows[index]["BID_TOTAL"] = txtTotBid.Text; 
                    ds.Tables[0].Rows[index]["NEW_Bid"] = lblNEW_Bid.Text;
                    ds.Tables[0].Rows[index]["VARIANCE"] = lblVARIANCE.Text = Convert.ToDouble(lblVARIANCE.Text.Trim()).ToString("#,##0.00");
                    ds.Tables[0].Rows[index]["company"] = ddlCompany.SelectedItem.Text;

                    dt.AcceptChanges();
                    ViewState["dsForecastAnls"] = ds;
                    ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL")).Focus();
                    BindSummaryGrid();
                }
                else
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate can not be blank!')", true);
                    ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE")).Focus();
                    return;
                }
            }
            catch
            {
            }
        } 
    

        protected void gdvSummary_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.Header)
            {
                e.Row.Cells[1].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[2].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[3].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[4].HorizontalAlign = HorizontalAlign.Right;
            }

            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                e.Row.Cells[1].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[2].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[3].HorizontalAlign = HorizontalAlign.Right;
                e.Row.Cells[4].HorizontalAlign = HorizontalAlign.Right;

                double BID_TOTAL = Convert.ToDouble(e.Row.Cells[2].Text.ToString());
                e.Row.Cells[2].Text = BID_TOTAL.ToString("#,##0.00");
                double SCEG_forecast = Convert.ToDouble(e.Row.Cells[3].Text.ToString());
                e.Row.Cells[3].Text = SCEG_forecast.ToString("#,##0.00");
                double VARIANCE = Convert.ToDouble(e.Row.Cells[4].Text.ToString());
                e.Row.Cells[4].Text = VARIANCE.ToString("#,##0.00");

                if (e.Row.Cells[0].Text == "Total")
                {
                    //e.Row.Font.Bold = true;
                    e.Row.ForeColor = System.Drawing.Color.Red;
                }
            }
        }

        void BindSummaryGrid()
        {
            try
            {
                DataSet ds = (DataSet)ViewState["dsForecastAnls"];

                //DataSet ds = gdv_Forescast_Analysis.DataSource as DataSet;
                DataView dv = new DataView(ds.Tables[0]);
                dv.RowFilter = "company <> '' AND company <> '-Select-'";
                DataTable dt = dv.ToTable(true, new string[] { "COMPANY" });

                dt.Columns.Add("TOTAL_MILES", typeof(double));
                dt.Columns.Add("BID_TOTAL", typeof(double));
                dt.Columns.Add("SCEG_forecast", typeof(double));
                dt.Columns.Add("VARIANCE", typeof(double));

                double totMiles=0.0;
                double bidTotal=0.0;
                double SCEG_forecast = 0.0;
                double VARIANCE = 0.0;
                foreach (DataRow dr in dt.Rows)
                {
                    dr["TOTAL_MILES"] = ds.Tables[0].Compute("Sum(" + "TOTAL_MILES" + ")", "COMPANY" + " = '" + dr["COMPANY"] + "'");
                    dr["BID_TOTAL"] = ds.Tables[0].Compute("Sum(" + "BID_TOTAL" + ")", "COMPANY" + " = '" + dr["COMPANY"] + "'");
                    dr["SCEG_forecast"] = ds.Tables[0].Compute("Sum(" + "SCEG_forecast" + ")", "COMPANY" + " = '" + dr["COMPANY"] + "'");
                    dr["VARIANCE"] = ds.Tables[0].Compute("Sum(" + "VARIANCE" + ")", "COMPANY" + " = '" + dr["COMPANY"] + "'");
                    totMiles = totMiles + Convert.ToDouble(dr["TOTAL_MILES"].ToString());
                    bidTotal = bidTotal + Convert.ToDouble(dr["BID_TOTAL"].ToString());
                    SCEG_forecast = SCEG_forecast + Convert.ToDouble(dr["SCEG_forecast"].ToString());
                    VARIANCE = VARIANCE + Convert.ToDouble(dr["VARIANCE"].ToString());
                    //dr["VARIANCE"] = Convert.ToDouble(dr["VARIANCE"]).ToString("#,##0.00");
                }

                //dt.DefaultView.Sort = "COMPANY ASC";
                DataRow dtRow = dt.NewRow();
                dtRow["COMPANY"] = "Total";
                dtRow["TOTAL_MILES"] = totMiles;
                dtRow["BID_TOTAL"] = bidTotal;
                dtRow["SCEG_forecast"] = SCEG_forecast.ToString("#,##0.00");
                dtRow["VARIANCE"] = bidTotal;
                dt.Rows.InsertAt(dtRow, dt.Rows.Count );
                dt.AcceptChanges();
                gdvSummary.DataSource = dt;
                gdvSummary.DataBind();
            }
            catch
            {
            }
        }

        protected void txtURBAN_RATE_TextChanged(object sender, EventArgs e)
        {
            DoCalculation(sender);
        }

        protected void txtRURAL_RATE_TextChanged(object sender, EventArgs e)
        {
            DoCalculation(sender);
        }

        protected void txtCLIMBING_RATE_TextChanged(object sender, EventArgs e)
        {
            DoCalculation(sender);
        }

       

        private void DoCalculation(object sender)
        {
            GridViewRow gvRow = (GridViewRow)(sender as Control).Parent.Parent;
            int index = gvRow.RowIndex;
            DataSet ds = (DataSet)ViewState["dsForecastAnls"];
            DataView dv = new DataView(ds.Tables[0]);
            DataTable dt = dv.ToTable();

            TextBox txtFLAT_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE"));
            TextBox txtURBAN_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtURBAN_RATE"));
            TextBox txtRURAL_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtRURAL_RATE"));
            TextBox txtCLIMBING_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtCLIMBING_RATE"));
            TextBox txtBID_TOTAL = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL"));
            Label lblNEW_Bid = ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblNEW_Bid"));
            CheckBox chk3Unit = ((CheckBox)gdv_Forescast_Analysis.Rows[index].FindControl("chk3Unit"));
            DropDownList ddlCompany = ((DropDownList)gdv_Forescast_Analysis.Rows[index].FindControl("ddlCompany"));
            

            double climbing = Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblCLIMBING")).Text.Trim());
            double rural = Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblRURAL")).Text.Trim());
            double urban = Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblURBAN")).Text.Trim());

            
            if ( (!ValidateControls(txtFLAT_RATE)) || (!ValidateControls(txtURBAN_RATE)) || (!ValidateControls(txtRURAL_RATE)) ) return;
            else
            {
                double totBid = (Convert.ToDouble(txtURBAN_RATE.Text.Trim()) * urban) +
                    (Convert.ToDouble(txtRURAL_RATE.Text.Trim()) * rural) + (Convert.ToDouble(txtCLIMBING_RATE.Text.Trim()) * climbing);
                txtBID_TOTAL.Text = totBid.ToString("#,##0.00");
                lblNEW_Bid.Text = totBid.ToString("#,##0.00");

                ds.Tables[0].Rows[index]["FLAT_RATE"] = Convert.ToDouble(txtFLAT_RATE.Text.ToString()).ToString("#,##0.00");
                ds.Tables[0].Rows[index]["URBAN_RATE"] = Convert.ToDouble(txtURBAN_RATE.Text.ToString()).ToString("#,##0.00");
                ds.Tables[0].Rows[index]["RURAL_RATE"] = Convert.ToDouble(txtRURAL_RATE.Text.ToString()).ToString("#,##0.00");
                ds.Tables[0].Rows[index]["CLIMBING_RATE"] = Convert.ToDouble(txtCLIMBING_RATE.Text.ToString()).ToString("#,##0.00");
                ds.Tables[0].Rows[index]["BID_TOTAL"] = Convert.ToDouble(txtBID_TOTAL.Text.ToString()).ToString("#,##0.00");
                ds.Tables[0].Rows[index]["NEW_Bid"] = Convert.ToDouble(lblNEW_Bid.Text.ToString()).ToString("#,##0.00");
                ds.Tables[0].Rows[index]["company"] = ddlCompany.SelectedItem.Text;

                dt.AcceptChanges();
                ViewState["dsForecastAnls"] = ds;
                BindSummaryGrid();
            }
            
        }


        private DataSet BindRate(int compId)
        {
            DataSet ds = new DataSet();
            List<OleDbParameter> OleDbParams = new List<OleDbParameter>();
            try
            {
                OleDbParams.Add(new OleDbParameter("V_YEAR_ID", ddl_Year.SelectedValue));
                OleDbParams.Add(new OleDbParameter("V_COMPANY_ID", compId));

                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_FA_SELECT_DEFAULT_RATE, OleDbParams);
                return ds;
            }
               
            catch
            {
            }
            //finally
            //{
                
            //    ds.Clear();
            //    ds.Dispose();
            //}
            return ds;
        }

        protected void txtUrbanRate_TextChanged(object sender, EventArgs e)
        {
            ValidateScegRates(txtUrbanRate);
            if (gdv_Forescast_Analysis.Rows.Count > 0)
                CalculateScegRates();
            //if (!ValidateControls(txtUrbanRate)) { txtUrbanRate.Focus();  }
        }

        protected void txtRuralRate_TextChanged(object sender, EventArgs e)
        {
            ValidateScegRates(txtRuralRate);
            if (gdv_Forescast_Analysis.Rows.Count > 0)
                CalculateScegRates();
            //if (!ValidateControls(txtRuralRate)) { txtRuralRate.Focus();  }
        }

        protected void txtClimbRate_TextChanged(object sender, EventArgs e)
        {
            ValidateScegRates(txtClimbRate);
            if (gdv_Forescast_Analysis.Rows.Count > 0 )
                CalculateScegRates();
        }


        private void ValidateScegRates(TextBox txtBox)
        {
            double cntrlValue = 0.0;
            try
                {
                    cntrlValue = Convert.ToDouble(txtBox.Text);
                    if (txtBox.ID == "txtUrbanRate") txtRuralRate.Focus();
                    else if (txtBox.ID == "txtRuralRate") txtClimbRate.Focus();
                    else if (txtBox.ID == "txtClimbRate")
                    {
                        if (ddl_Year.SelectedIndex > 0) txtSandBoxDesc.Focus();
                        else if (txtSandBoxDesc.Text.Trim().Length > 0) btnGo.Focus();
                        else ddl_Year.Focus(); 
                    }
                }
                catch (Exception ex)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Non-Numeric value is not allowed!')", true);
                    txtBox.Text="";
                    txtBox.Focus();
                    return;
                }
        

            if (radBtnView.Checked)
            {
                int res = 1;

                if (ddl_Year.SelectedIndex == 0)
                    { ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select a year!')", true); ddl_Year.Focus(); res = 0; }
                else if (ddlVmtUser.SelectedIndex == 0)
                    { ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select an user!')", true); ddlVmtUser.Focus(); res = 0; }
                else if (ddlSandBox.SelectedIndex == 0)
                    { ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select a sandbox!')", true); ddlSandBox.Focus(); res = 0; }

                if (res == 0)
                {
                    //gdv_Forescast_Analysis.DataSource = null;
                    //gdv_Forescast_Analysis.DataBind();

                    //gdvSummary.DataSource = null;
                    //gdvSummary.DataBind();
                    return;
                }
                else
                {
                    //bindGrid();
                    //BindSummaryGrid();
                }
            }
            //if (radBtnCreate.Checked)
            //{
            //    if (ddl_Year.SelectedIndex == 0)
            //        ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select a year!')", true);
            //    //if (txtSandBoxDesc.Text.Trim().Length == 0)
            //    //    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Enter sandbox description!')", true);

            //}


            

            //gdv_Forescast_Analysis.DataSource = null;
                //gdv_Forescast_Analysis.DataBind();
                
                //gdvSummary.DataSource = null;
                //gdvSummary.DataBind();

                //if (txtUrbanRate.Text.Length == 0)
                //    txtUrbanRate.Focus();
                //else if (txtRuralRate.Text.Length == 0)
                //    txtRuralRate.Focus();
                //else
                //    txtClimbRate.Focus();
           
        }

        private bool ValidateControls(Control cntrl)
        {
            double cntrlValue = 0.0;

                try
                {
                    if (cntrl is TextBox)
                        cntrlValue = Convert.ToDouble((cntrl as TextBox).Text);
                    else if (cntrl is Label)
                        cntrlValue = Convert.ToDouble((cntrl as Label).Text);
                }
                catch (Exception ex)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Non-Numeric value is not allowed!')", true);
                    cntrl.Focus();
                    if (cntrl is TextBox)
                       (cntrl as TextBox).Text="";
                    else if (cntrl is Label)
                        (cntrl as Label).Text = "";
                    return false;
                }
                return true;
        }

        protected void txtBID_TOTAL_TextChanged(object sender, EventArgs e)
        {
             try
            {
                GridViewRow gvRow = (GridViewRow)(sender as Control).Parent.Parent;
                int index = gvRow.RowIndex;
                DataSet ds = (DataSet)ViewState["dsForecastAnls"];
                DataView dv = new DataView(ds.Tables[0]);
                DataTable dt = dv.ToTable();

                TextBox txtFLAT_RATE = (TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE");
                Label lblVARIANCE = ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblVARIANCE"));
                TextBox txtTotBid = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL"));
                Label lblNEW_Bid = ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblNEW_Bid"));
                DropDownList ddlCompany = ((DropDownList)gdv_Forescast_Analysis.Rows[index].FindControl("ddlCompany"));

                double totBid = 0.0;

                if (txtTotBid.Text.Trim().Length > 0)
                {
                    if (!ValidateControls(txtTotBid))
                    {
                        txtTotBid.Text = "0";
                        lblNEW_Bid.Text = "0";
                        lblVARIANCE.Text = (0 - Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblSCEG_forecast")).Text.Trim())).ToString("#,##0.00");
                    }

                    else
                    {
                        totBid = Convert.ToDouble(txtTotBid.Text.ToString());
                        ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblVARIANCE")).Text = (totBid -
                            Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblSCEG_forecast")).Text.Trim())).ToString("#,##0.00");
                    }
                    ds.Tables[0].Rows[index]["BID_TOTAL"] = txtTotBid.Text = totBid.ToString("#,##0.00"); ; 
                    ds.Tables[0].Rows[index]["VARIANCE"] = lblVARIANCE.Text = Convert.ToDouble(lblVARIANCE.Text.Trim()).ToString("#,##0.00");
                    ds.Tables[0].Rows[index]["company"] = ddlCompany.SelectedItem.Text;

                    dt.AcceptChanges();
                    ViewState["dsForecastAnls"] = ds;
                    ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL")).Focus();
                    BindSummaryGrid();
                }
                 
                else
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Bid total can not be blank!')", true);
                    ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL")).Focus();
                    return;
                }
            }
            catch{}
        }

        int retVal = 0;
        
        


        protected void radBtnCreate_CheckedChanged(object sender, EventArgs e)
        {
            //ddl_Year.Enabled = false;
            ddl_Bunit.Enabled = false;
            ddlVmtUser.Enabled = false;
            ddlVmtUser.Visible = false;
            lblVmtUser.Visible = true;
            if (ddl_Year.Items.Count > 0) ddl_Year.SelectedIndex = 0;
            if (ddlSandBox.Items.Count > 0) ddlSandBox.SelectedIndex = 0;
            if (ddlVmtUser.Items.Count > 0) ddlVmtUser.SelectedIndex = 0;

            btnSubmitSandBox.Visible = true;
         
            txtSandBoxDesc.Visible = true;
            txtSandBoxDesc.Text = "";
            ddlSandBox.Visible = false;
            //divCreateSandBox.Visible = true;
            btnGo.Visible = true;
            btnExportExcel.Visible = false;

            ddl_Year.Focus();
            txtUrbanRate.Enabled = true;
            txtRuralRate.Enabled = true;
            txtClimbRate.Enabled = true;
            txtUrbanRate.Text = "";
            txtRuralRate.Text = "";
            txtClimbRate.Text = "";

            bindGrid();
            if (gdv_Forescast_Analysis.Rows.Count == 0)
            { gdvSummary.DataSource = null; gdvSummary.DataBind(); }

        }

        protected void radBtnView_CheckedChanged(object sender, EventArgs e)
        {
            ddl_Bunit.Enabled = true;
            //ddl_Year.Enabled = true;
            ddlVmtUser.Enabled = true;
            ddlVmtUser.Visible = true;
            lblVmtUser.Visible = false;
            if (ddl_Year.Items.Count > 0) ddl_Year.SelectedIndex = 0;
            if (ddlSandBox.Items.Count > 0) ddlSandBox.SelectedIndex = 0;
            if (ddlVmtUser.Items.Count > 0) ddlVmtUser.SelectedIndex = 0;
            btnSubmitSandBox.Visible = false;
            txtSandBoxDesc.Visible = false;
            ddlSandBox.Visible = true;
            divCreateSandBox.Visible = false;
            btnGo.Visible = false;
            
            txtUrbanRate.Text = "";
            txtRuralRate.Text = "";
            txtClimbRate.Text = "";

            
            bindGrid();
            if (gdv_Forescast_Analysis.Rows.Count == 0)
            {gdvSummary.DataSource = null; gdvSummary.DataBind();}
        }

        protected void ddlSandBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            GetSandBoxDetail(Convert.ToInt32(ddl_Bunit.SelectedValue), Convert.ToInt32(ddl_Year.SelectedValue), ddlVmtUser.SelectedItem.Text, Convert.ToInt32(ddlSandBox.SelectedValue));
        }

        private void GetSandBoxDetail(int V_BUSINESS_UNIT_ID, int V_YEAR, string V_LAST_UPDATED_USER_ID, int V_SANDBOX_ID)
        { 
                DataSet ds =new DataSet();
                try
                {
                    List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                    OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                    OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
                    OledbParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID",V_LAST_UPDATED_USER_ID));
                    OledbParams.Add(new OleDbParameter("V_SANDBOX_ID", V_SANDBOX_ID));

                    //ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam(m_SP_FA_SELECT_SANDBOX_DETAIL, OledbParams);
                    //gdv_Forescast_Analysis.DataSource = null;
                    //gdv_Forescast_Analysis.DataBind();
                    //gdv_Forescast_Analysis.DataSource = ds;
                    //gdv_Forescast_Analysis.DataBind();

                    DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_FA_SELECT_SANDBOX_DETAIL, OledbParams, gdv_Forescast_Analysis);
                   
                    ds = (DataSet)gdv_Forescast_Analysis.DataSource;
                    ViewState["dsForecastAnls"] = ds;
                    
                   

                    if (ds.Tables[0].Rows.Count>0) btnExportExcel.Visible=true;
                    else btnExportExcel.Visible = false;

                    txtUrbanRate.Text =  Convert.ToDouble(ds.Tables[0].Rows[0]["SCEG_FRECAST_URBAN_RATE"]).ToString("#,##0.00");
                    txtRuralRate.Text =  Convert.ToDouble(ds.Tables[0].Rows[0]["SCEG_FRECAST_RURAL_RATE"]).ToString("#,##0.00");
                    txtClimbRate.Text = Convert.ToDouble(ds.Tables[0].Rows[0]["SCEG_FRECAST_CLIMBING_RATE"]).ToString("#,##0.00");
                    BindSummaryGrid();

                    if (ds.Tables[0].Rows[0]["STATUS"].ToString() == "S")
                    {
                        divCreateSandBox.Visible = true;
                        btnSubmitSandBox.Visible = true;
                        btnSubmitSandBox.Enabled = true;
                        btnPostSandBox.Visible = true;
                        btnPostSandBox.Enabled = true;
                        txtUrbanRate.Enabled = true;
                        txtRuralRate.Enabled = true;
                        txtClimbRate.Enabled = true;
                    }
                    else
                    {
                        divCreateSandBox.Visible = false;
                        txtUrbanRate.Enabled = false;
                        txtRuralRate.Enabled = false;
                        txtClimbRate.Enabled = false;
                    }

                }
                catch
                {
                }

        }


        protected void ddlVmtUser_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindSandBoxNames();
        }

        protected void ddlVmtUser_DataBound(object sender, EventArgs e)
        {
            BindSandBoxNames();
        }

       


        protected void ddl_Year_DataBound(object sender, EventArgs e)
        {
            BindVmtUsers();
        }

        protected void ddl_Year_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindVmtUsers();
            txtSandBoxDesc.Text = "";
        }

        private void BindSandBoxNames()
        {
            int V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
            int V_YEAR_ID = Convert.ToInt32(ddl_Year.SelectedItem.Value);
            string V_LAST_UPDATED_USER_ID = string.Empty;
            if (radBtnCreate.Checked)
                V_LAST_UPDATED_USER_ID = lblVmtUser.Text;
            else
                V_LAST_UPDATED_USER_ID = ddlVmtUser.SelectedItem.Value;
            List<OleDbParameter> OledbParams = new List<OleDbParameter>();
            OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
            OledbParams.Add(new OleDbParameter("V_YEAR_ID", V_YEAR_ID));
            OledbParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", V_LAST_UPDATED_USER_ID));
            try
            {
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_FA_SELECT_SANDBOX_NAMES, OledbParams, ddlSandBox);
            }
            catch
            {
            }
        }

        private void BindVmtUsers()
        {
            
                int V_BUSINESS_UNIT_ID = Convert.ToInt32(ddl_Bunit.SelectedValue);
                int V_YEAR_ID = Convert.ToInt32(ddl_Year.SelectedItem.Value);
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
                OledbParams.Add(new OleDbParameter("V_YEAR_ID", V_YEAR_ID));
                try
                {
                    DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_FA_SELECT_SANDBOX_VMTUSERS, OledbParams, ddlVmtUser);
                }
                catch
                {
                }
            
        }       

        protected void btnGo_Click(object sender, EventArgs e)
        {
            if (ddl_Year.SelectedIndex == 0)
                { ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select a year !')", true); ddl_Year.Focus(); }
            else if (txtSandBoxDesc.Text.Trim().Length == 0)
                { ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Enter sandbox description !')", true); txtSandBoxDesc.Focus();  }

            else if (!ValidateControls(txtUrbanRate)) {txtUrbanRate.Focus();  }
            else if (!ValidateControls(txtRuralRate)) { txtRuralRate.Focus();  }
            else if (!ValidateControls(txtClimbRate)) { txtClimbRate.Focus();  }
            else{
                gdvSummary.DataSource = null;
                gdvSummary.DataBind();
                bindGrid();
            }

            CheckButtonVisibility();
        }

        void CheckButtonVisibility()
        {
            if (hdn_role.Value == "2")
            {
                divCreateSandBox.Visible = true;
                btnSubmitSandBox.Visible = true;
                btnPostSandBox.Visible = true;
            }
            else if (hdn_role.Value == "3")
            {
                divCreateSandBox.Visible = true;
                btnSubmitSandBox.Visible = true;
                btnPostSandBox.Visible = true;
            }
            else if (hdn_role.Value == "1")
            {
                divCreateSandBox.Visible = false;
                btnSubmitSandBox.Visible = false;
                btnPostSandBox.Visible = false;
            }
            else if (hdn_role.Value == "0")
            {
                Response.Redirect("Default.aspx");
            }
        }

        protected void btnSubmitSandBox_Click(object sender, EventArgs e)
        {
            SaveUpdateSandBox(sender);
        }

        protected void btnPostSandBox_Click(object sender, EventArgs e)
        {
            
            SaveUpdateSandBox(sender);
            GetSandBoxDetail(Convert.ToInt32(ddl_Bunit.SelectedValue), Convert.ToInt32(ddl_Year.SelectedValue), ddlVmtUser.SelectedItem.Text, Convert.ToInt32(ddlSandBox.SelectedValue));
        }

        private void CalculateScegRates()
        { 
            DataSet ds = (DataSet)ViewState["dsForecastAnls"];
            DataView dv = new DataView(ds.Tables[0]);
            DataTable dt = dv.ToTable();

            

            foreach (GridViewRow row in gdv_Forescast_Analysis.Rows)
            {
                Label lblSCEG_forecast = ((Label)row.FindControl("lblSCEG_forecast"));
                Label lblVARIANCE = ((Label)row.FindControl("lblVARIANCE"));
                TextBox txtBID_TOTAL = ((TextBox)row.FindControl("txtBID_TOTAL"));

                double climbing = Convert.ToDouble(((Label)row.FindControl("lblCLIMBING")).Text.Trim());
                double rural = Convert.ToDouble(((Label)row.FindControl("lblRURAL")).Text.Trim());
                double urban = Convert.ToDouble(((Label)row.FindControl("lblURBAN")).Text.Trim());

                if ((txtUrbanRate.Text.Length > 0) || (txtRuralRate.Text.Length > 0) || (txtClimbRate.Text.Length > 0))
                {
                    double SCEG_forecast = (Convert.ToDouble(txtUrbanRate.Text.Trim()) * urban) +
                        (Convert.ToDouble(txtRuralRate.Text.Trim()) * rural) + (Convert.ToDouble(txtClimbRate.Text.Trim()) * climbing);

                    ds.Tables[0].Rows[row.RowIndex]["SCEG_forecast"] = lblSCEG_forecast.Text = Convert.ToDouble(SCEG_forecast).ToString("#,##0.00");
                    ds.Tables[0].Rows[row.RowIndex]["VARIANCE"] = lblVARIANCE.Text = (Convert.ToDouble(txtBID_TOTAL.Text.Trim()) - Convert.ToDouble(lblSCEG_forecast.Text.ToString())).ToString("#,##0.00");

                }

            }
            dt.AcceptChanges();
            //ds = (DataSet)gdv_Forescast_Analysis.DataSource;
            ViewState["dsForecastAnls"] = ds;
            BindSummaryGrid();
        
        }

        private void SaveUpdateSandBox(object sender)
        {
            String V_STATUS = "";
            Button btn = (Button)sender;
            if (btn.Text == "Save") V_STATUS = "S";
            else V_STATUS = "P";

            string user=System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper();
            try
            {
                
                    if (radBtnCreate.Checked && txtSandBoxDesc.Text.Length == 0)
                    {
                        ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('SandBox description could not be blank!')", true);
                        txtSandBoxDesc.Focus();
                        return;
                    }

                    string V_BID_DESCRIPTION = string.Empty;
                    string V_ACTION = string.Empty;
                    if (radBtnCreate.Checked) 
                    {
                        V_BID_DESCRIPTION = txtSandBoxDesc.Text.Trim();
                        V_ACTION = "CRATATE";
                    }
                    else
                    {
                        V_BID_DESCRIPTION = ddlSandBox.SelectedItem.Text;
                        V_ACTION = "UPDATE";
                    }

                    List<OleDbParameter> sqlParamsSH = new List<OleDbParameter>();
                    sqlParamsSH.Add(new OleDbParameter("V_BID_DESCRIPTION", V_BID_DESCRIPTION));
                    sqlParamsSH.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_Bunit.SelectedValue));
                    sqlParamsSH.Add(new OleDbParameter("V_YEAR_ID", ddl_Year.SelectedValue));
                    sqlParamsSH.Add(new OleDbParameter("V_SCEG_FRECAST_URBAN_RATE", txtUrbanRate.Text.Trim()));
                    sqlParamsSH.Add(new OleDbParameter("V_SCEG_FRECAST_RURAL_RATE", txtRuralRate.Text.Trim()));
                    sqlParamsSH.Add(new OleDbParameter("V_SCEG_FRECAST_CLIMBING_RATE", txtClimbRate.Text.Trim()));
                    sqlParamsSH.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", user));
                    sqlParamsSH.Add(new OleDbParameter("V_STATUS", V_STATUS));
                    sqlParamsSH.Add(new OleDbParameter("V_ACTION", V_ACTION));

                    ViewState["SANDBOX_ID"] = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_FA_SANDBOX_HEADER_INS, sqlParamsSH);
                    if (radBtnCreate.Checked && Int32.Parse(ViewState["SANDBOX_ID"].ToString()) == -1)
                    {
                        ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('SandBox alreday exists!')", true);
                        txtSandBoxDesc.Focus();
                        return;
                    }

                    else
                    {
                        //gdv_Forescast_Analysis.DataSource = (DataSet)ViewState["dsForecastAnls"];
                        //gdv_Forescast_Analysis.DataBind();
                
                    foreach (GridViewRow row in gdv_Forescast_Analysis.Rows)
                    {
                        TextBox txtFLAT_RATE = ((TextBox)row.FindControl("txtFLAT_RATE"));
                        TextBox txtURBAN_RATE = ((TextBox)row.FindControl("txtURBAN_RATE"));
                        
                        TextBox txtRURAL_RATE = ((TextBox)row.FindControl("txtRURAL_RATE"));
                        TextBox txtCLIMBING_RATE = ((TextBox)row.FindControl("txtCLIMBING_RATE"));
                        TextBox txtBID_TOTAL = ((TextBox)row.FindControl("txtBID_TOTAL"));
                        CheckBox chk3Unit = ((CheckBox)row.FindControl("chk3Unit"));
                        DropDownList ddlCompany = ((DropDownList)row.FindControl("ddlCompany"));

                        Label lblDIST_ID = ((Label)row.FindControl("lblDIST_ID"));
                        Label lblEVENT_CODE_ID = ((Label)row.FindControl("lblEVENT_CODE_ID"));
                        Label lblURBAN = ((Label)row.FindControl("lblURBAN"));
                        Label lblRURAL = ((Label)row.FindControl("lblRURAL"));
                        Label lblCLIMBING = ((Label)row.FindControl("lblCLIMBING"));
                        Label lblTOTAL_MILES = ((Label)row.FindControl("lblTOTAL_MILES"));

                        string threeUnit = "N";
                        int compId = 0;
                        if (ddlCompany.SelectedIndex != 0)
                        {
                            compId = Convert.ToInt32(ddlCompany.SelectedValue);
                            if (chk3Unit.Checked) threeUnit = "Y";
                            else threeUnit = "N";
                        }


                        List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                        if (radBtnCreate.Checked) //status == "S")
                            sqlParams.Add(new OleDbParameter("V_SANDBOX_ID", ViewState["SANDBOX_ID"]));
                        else
                        {
                            sqlParams.Add(new OleDbParameter("V_SANDBOX_ID", ddlSandBox.SelectedValue));
                             ViewState["SANDBOX_ID"] =ddlSandBox.SelectedValue ;
                        }
                        sqlParams.Add(new OleDbParameter("V_DISTRICT_ID", lblDIST_ID.Text.Trim()));
                        sqlParams.Add(new OleDbParameter("V_EVENTCODE_ID", string.IsNullOrEmpty(lblEVENT_CODE_ID.Text.Trim()) ? 0 : Convert.ToInt32(lblEVENT_CODE_ID.Text.Trim())));
                        sqlParams.Add(new OleDbParameter("V_URBAN_LENGTH", string.IsNullOrEmpty(lblURBAN.Text.Trim()) ? 0 : Convert.ToDouble(lblURBAN.Text.Trim())));
                        sqlParams.Add(new OleDbParameter("V_RURAL_LENGTH", string.IsNullOrEmpty(lblRURAL.Text.Trim()) ? 0 : Convert.ToDouble(lblRURAL.Text.Trim())));
                        sqlParams.Add(new OleDbParameter("V_CLIMBING_LENGTH", string.IsNullOrEmpty(lblCLIMBING.Text.Trim()) ? 0 : Convert.ToDouble(lblCLIMBING.Text.Trim())));
                        sqlParams.Add(new OleDbParameter("V_TOTAL_MILES", string.IsNullOrEmpty(lblCLIMBING.Text.Trim()) ? 0 : Convert.ToDouble(lblTOTAL_MILES.Text.Trim())));
                        sqlParams.Add(new OleDbParameter("V_COMANY_ID", compId));
                        sqlParams.Add(new OleDbParameter("V_THREE_UNIT", threeUnit));
                        sqlParams.Add(new OleDbParameter("V_FLAT_RATE", string.IsNullOrEmpty(txtFLAT_RATE.Text.Trim()) ? 0 : Convert.ToDouble(txtFLAT_RATE.Text.Trim())));
                        sqlParams.Add(new OleDbParameter("V_URBAN_RATE", string.IsNullOrEmpty(txtURBAN_RATE.Text.Trim()) ? 0 : Convert.ToDouble(txtURBAN_RATE.Text.Trim())));
                        sqlParams.Add(new OleDbParameter("V_RURAL_RATE", string.IsNullOrEmpty(txtRURAL_RATE.Text.Trim()) ? 0 : Convert.ToDouble(txtRURAL_RATE.Text.Trim())));
                        sqlParams.Add(new OleDbParameter("V_CLIMBING_RATE", string.IsNullOrEmpty(txtCLIMBING_RATE.Text.Trim()) ? 0 : Convert.ToDouble(txtCLIMBING_RATE.Text.Trim())));
                        sqlParams.Add(new OleDbParameter("V_BID_TOTAL", string.IsNullOrEmpty(txtBID_TOTAL.Text.Trim()) ? 0 : Convert.ToDouble(txtBID_TOTAL.Text.Trim())));
                        sqlParams.Add(new OleDbParameter("V_STATUS", V_STATUS));
                        int res = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_FA_SANDBOX_DETAIL_INS, sqlParams);

                        
                    }

                    if (radBtnCreate.Checked && btn.Text == "Save")
                    {
                        BindVmtUsers();
                        BindSandBoxNames();
                         ddlSandBox.SelectedValue = ViewState["SANDBOX_ID"].ToString();
                        radBtnCreate.Checked = false;                        
                        radBtnView.Checked = true;
                        ddlVmtUser.Enabled = true;
                        ddlVmtUser.Visible = true;
                        lblVmtUser.Visible = false;
                        btnSubmitSandBox.Visible = true;
                        txtSandBoxDesc.Visible = false;
                        ddlSandBox.Visible = true;
                        divCreateSandBox.Visible = false;
                        btnGo.Visible = false;

                        
                        ddlVmtUser.SelectedValue = user;
                        GetSandBoxDetail(Convert.ToInt32(ddl_Bunit.SelectedValue), Convert.ToInt32(ddl_Year.SelectedValue), user, Convert.ToInt32(ViewState["SANDBOX_ID"]));
                    }

                    if (btn.Text != "Save")
                    {
                        txtUrbanRate.Text = "";
                        txtRuralRate.Text = "";
                        txtClimbRate.Text = "";
                        gdv_Forescast_Analysis.DataSource = null;
                        gdv_Forescast_Analysis.DataBind();
                        gdvSummary.DataSource = null;
                        gdvSummary.DataBind();
                        txtSandBoxDesc.Text = "";
                    }
                    
                }
            }
            catch { }
            finally
            {
                //sqlParams.Clear();
                
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('SandBox data added successfully ')", true);
            
            }

        }

        

       
 #region "old-code"



        //private double ConvertToDouble(Control cntrl, int PreciseDecimalValue)
        //{
        //    double cntrlValue = 0.0;

        //    try
        //    {
        //        if (cntrl is TextBox)
        //            cntrlValue = Convert.ToDouble((cntrl as TextBox).Text);
        //        else if (cntrl is Label)
        //            cntrlValue = Convert.ToDouble((cntrl as Label).Text);

        //        if (PreciseDecimalValue == 2)
        //            cntrlValue = Convert.ToDouble(String.Format("{0:0.00}", cntrlValue));
        //        else if (PreciseDecimalValue == 3)
        //            cntrlValue = Convert.ToDouble(String.Format("{0:0.000}", cntrlValue));
        //        return cntrlValue;
        //    }
        //    catch (Exception ex)
        //    {
        //        ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Non-Numeric value is not allowed!')", true);
        //        cntrl.Focus();
        //        return cntrlValue;
        //    }


            //return cntrlValue; 
        //}

        //protected void chk3Unit_CheckedChanged(object sender, EventArgs e)
        //{

        //    GridViewRow gvRow = (GridViewRow)(sender as Control).Parent.Parent;
        //    int index = gvRow.RowIndex;
        //    DataSet ds = (DataSet)ViewState["dsForecastAnls"];
        //    DataView dv = new DataView(ds.Tables[0]);
        //    DataTable dt = dv.ToTable();

        //    TextBox txtFLAT_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE"));
        //    TextBox txtURBAN_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtURBAN_RATE"));
        //    TextBox txtRURAL_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtRURAL_RATE"));
        //    TextBox txtCLIMBING_RATE = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtCLIMBING_RATE"));
        //    TextBox txtBID_TOTAL = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL"));
        //    Label lblNEW_Bid = ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblNEW_Bid"));
        //    CheckBox chk3Unit = ((CheckBox)gdv_Forescast_Analysis.Rows[index].FindControl("chk3Unit"));

        //    if (chk3Unit.Checked )
        //    {

        //        ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtURBAN_RATE")).Focus();
        //        Label lblNewBid = ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblNEW_Bid"));
        //        TextBox txtCLIMBING = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtCLIMBING_RATE"));
        //        ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtCLIMBING_RATE")).Enabled = true;
        //        double climbing = Convert.ToDouble(((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtCLIMBING_RATE")).Text.Trim());
        //        ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtRURAL_RATE")).Enabled = true;
        //        double rural = Convert.ToDouble(((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtRURAL_RATE")).Text.Trim());
        //        ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtURBAN_RATE")).Enabled = true;
        //        double urban = Convert.ToDouble(((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtURBAN_RATE")).Text.Trim());
        //        ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE")).Enabled = false;

        //        if ((txtClimbRate.Text.Length > 0) || (txtRuralRate.Text.Length > 0) || (txtUrbanRate.Text.Length > 0))
        //        {

        //            double newBidTotal = (Convert.ToDouble(txtClimbRate.Text.Trim()) * climbing) + (Convert.ToDouble(txtRuralRate.Text.Trim()) * rural) + (Convert.ToDouble(txtUrbanRate.Text.Trim()) * urban);
        //            lblNewBid.Text = newBidTotal.ToString();
        //            ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblVARIANCE")).Text = (Convert.ToDouble(((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL")).Text.Trim()) - Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblTOTAL_FORECASTED")).Text.Trim())).ToString();

        //            ds.Tables[0].Rows[index]["CLIMBING"] = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtCLIMBING_RATE")).Text.Trim();
        //            ds.Tables[0].Rows[index]["RURAL"] = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtRURAL_RATE")).Text.Trim();
        //            ds.Tables[0].Rows[index]["URBAN"] = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtURBAN_RATE")).Text.Trim();
        //            ds.Tables[0].Rows[index]["NEW_Bid"] = ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblNEW_Bid")).Text.Trim();
        //            ds.Tables[0].Rows[index]["VARIANCE"] = ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblVARIANCE")).Text.Trim();

        //            dt.AcceptChanges();
        //            ViewState["dsForecastAnls"] = ds;
        //            BindSummaryGrid();
        //        }
        //        else
        //        {
        //            ((CheckBox)gdv_Forescast_Analysis.Rows[index].FindControl("chk3Unit")).Checked = false;
        //            ((CheckBox)gdv_Forescast_Analysis.Rows[index].FindControl("chk3Unit")).Focus();
        //            ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtCLIMBING_RATE")).Enabled = false;
        //            ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtRURAL_RATE")).Enabled = false;
        //            ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtURBAN_RATE")).Enabled = false;
        //            //((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE")).Enabled = true;

        //        }

        //    }
        //    else
        //    {
        //        ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE")).Focus();
        //        ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtCLIMBING_RATE")).Enabled = false;
        //        ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtRURAL_RATE")).Enabled = false;
        //        ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtURBAN_RATE")).Enabled = false;
        //        ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE")).Enabled = true;

        //        if (((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE")).Text.Trim().Length > 0)
        //        {
        //            double rate = Convert.ToDouble(((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE")).Text.Trim());
        //            double totMiles = Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblTOTAL_MILES")).Text.Trim());
        //            double totBid = rate * totMiles;
        //            TextBox txtTotBid = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL"));
        //            txtTotBid.Text = totBid.ToString();
        //            ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblVARIANCE")).Text = (totBid - Convert.ToDouble(((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblTOTAL_FORECASTED")).Text.Trim())).ToString();

        //            ds.Tables[0].Rows[index]["FLAT_RATE"] = txtTotBid.Text; //((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE")).Text.Trim();
        //            ds.Tables[0].Rows[index]["BID_TOTAL"] = txtTotBid.Text; //((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL")).Text.Trim();
        //            dt.AcceptChanges();
        //            ViewState["dsForecastAnls"] = ds;
        //            BindSummaryGrid();
        //        }
        //        else
        //        {
        //            ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Rate can not be blank!')", true);
        //            ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtFLAT_RATE")).Focus();
        //            return;
        //        }


        //        ((Label)gdv_Forescast_Analysis.Rows[index].FindControl("lblNEW_Bid")).Text = ((TextBox)gdv_Forescast_Analysis.Rows[index].FindControl("txtBID_TOTAL")).Text;
        //    }
        //}
 #endregion

    }
}
