﻿using DataAccess;
using System;
using System.Collections.Generic;
using System.Data.OleDb;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace VMT
{
    public partial class Flight_Record_Status : System.Web.UI.Page
    {
        string m_SP_FRS_SELECT_FLIGHT_TYPE = Properties.Settings.Default.SP_FRS_SELECT_FLIGHT_TYPE;
        string m_SP_FRS_SELECT_FLIGHT_YEAR = Properties.Settings.Default.SP_FRS_SELECT_FLIGHT_YEAR;
        string m_SP_FRS_SELECT_FLIGHT_RECORDS = Properties.Settings.Default.SP_FRS_SELECT_FLIGHT_RECORDS;
        string m_SP_FRS_UPD_FLIGHT_REC_STATUS = Properties.Settings.Default.SP_FRS_UPD_FLIGHT_REC_STATUS;

        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Flight Inspection Close";
        protected void Page_Load(object sender, EventArgs e)
        {
           
            if (!Page.IsPostBack)
            {


                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                bindFlightType();
                bindFlightYear();
                bindGrid();

            }

        }
        private void bindGrid()
        {
           // gdvFlightRecord.DataBind();
            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();

                OleDbParams.Add(new OleDbParameter("v_flight_type_id", Convert.ToInt32(ddlFlightType.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("v_flight_year_id", Convert.ToInt32(ddlFlightYear.SelectedValue)));
                DataAccessUtility.BindGridViewViaProcedureWithParameter(m_SP_FRS_SELECT_FLIGHT_RECORDS, OleDbParams, gdvFlightRecord);
                gdvFlightRecord.SelectedIndex = -1;
            }
            catch
            {
            }
        }
        void bindFlightType()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_FRS_SELECT_FLIGHT_TYPE, ddlFlightType);
            }
            catch
            {
            }
        }
        void bindFlightYear()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_FRS_SELECT_FLIGHT_YEAR, ddlFlightYear);
            }
            catch
            {
            }
        }
        protected void ddlFlightType_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindGrid();
        }

        protected void cbSelectAll_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox ChkBoxHeader = (CheckBox)gdvFlightRecord.HeaderRow.FindControl("cbSelectAll");
            foreach (GridViewRow row in gdvFlightRecord.Rows)
            {
                CheckBox ChkBoxRows = (CheckBox)row.FindControl("cbSelect");
                if (ChkBoxRows.Enabled == true)
                {
                    if (ChkBoxHeader.Checked == true)
                    {
                        ChkBoxRows.Checked = true;
                    }
                    else
                    {
                        ChkBoxRows.Checked = false;
                    }
                }
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            int retVal = 0;
            int V_FLIGHT_RECORD_ID;
            int V_STATUS_ID;

            foreach (GridViewRow row in gdvFlightRecord.Rows)
            {
                if (((CheckBox)row.FindControl("cbSelect")).Checked)
                {

                    V_FLIGHT_RECORD_ID = Convert.ToInt32(((Label)row.FindControl("lbl_FLIGHT_RCD_ID")).Text);
                    V_STATUS_ID = 8;
                }

                else
                {
                    V_FLIGHT_RECORD_ID = Convert.ToInt32(((Label)row.FindControl("lbl_FLIGHT_RCD_ID")).Text);
                    V_STATUS_ID = 6;
                }

                
                try
                {
                    List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                    sqlParams.Add(new OleDbParameter("V_FLIGHT_RECORD_ID", V_FLIGHT_RECORD_ID));
                    sqlParams.Add(new OleDbParameter("V_FLIGHT_STATUS_ID", V_STATUS_ID));
                    sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                    retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_FRS_UPD_FLIGHT_REC_STATUS, sqlParams);
                }
                catch
                {
                }
            }

            if (retVal == 1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Update successful');", true);
            }
            else
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('No update done');", true);
            }
            bindGrid();
        }

        protected void ddlFlightYear_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindGrid();
        }


    }
}