﻿using DataAccess;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.OleDb;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace VMT
{
    public partial class Flight_Record_Creation : System.Web.UI.Page
    {
        string m_SP_FRC_SELECT_FLIGHT_TYPE = Properties.Settings.Default.SP_FRC_SELECT_FLIGHT_TYPE;
        string m_SP_FRC_SELECT_FLIGHT_YEAR = Properties.Settings.Default.SP_FRC_SELECT_FLIGHT_YEAR;
        string m_SP_FRC_SELECT_FLIGHT_RECORDS = Properties.Settings.Default.SP_FRC_SELECT_FLIGHT_RECORDS;
        string m_SP_FRC_FLIGHT_RECORD_INS_UPD = Properties.Settings.Default.SP_FRC_FLIGHT_RECORD_INS_UPD;
        string m_SP_FRC_SELECT_FLIGHT_EMP = Properties.Settings.Default.SP_FRC_SELECT_FLIGHT_EMP;

        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Create Flight Record";
        protected void Page_Load(object sender, EventArgs e)
        {
           
            if (!Page.IsPostBack)
            {

                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                bindFlightType();
                bindFlightYear();                
                BindGrid();

            }
        }

        void bindFlightType()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_FRC_SELECT_FLIGHT_TYPE, ddlFlightType0);
            }
            catch
            {
            }
        }
        void bindFlightYear()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_FRC_SELECT_FLIGHT_YEAR, ddlFlightYear0);
            }
            catch
            {
            }
        }
        void bindflightInspector()
        {
            int V_FLIGHT_TYPE_ID = Convert.ToInt32(ddlFlightType0.SelectedValue);
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_FLIGHT_TYPE_ID", V_FLIGHT_TYPE_ID));               
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_FRC_SELECT_FLIGHT_EMP, OledbParams, ddlFlightInspector);
            }
            catch
            {
            }
        }
        private void BindGrid()
        {
            gdv_list.DataBind();
            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();

                OleDbParams.Add(new OleDbParameter("v_flight_type_id", Convert.ToInt32(ddlFlightType0.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("v_flight_type_id", Convert.ToInt32(ddlFlightYear0.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("v_flight_inspector_id", ddlFlightInspector.SelectedValue));
                DataAccessUtility.BindGridViewViaProcedureWithParameter(m_SP_FRC_SELECT_FLIGHT_RECORDS, OleDbParams,gdv_list);
                gdv_list.SelectedIndex = -1;
            }
            catch
            {
            }
        }
        protected void gdv_list_RowCreated(object sender, GridViewRowEventArgs e)
        {
            //e.Row.Cells[0].Visible = false;
        }

        protected void btnAddnew_Click(object sender, EventArgs e)
        {
            if (ddlFlightType0.SelectedValue == "-1")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select flight type.')", true);
                return;
            }
            if (ddlFlightInspector.SelectedValue == "-1")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select Inspector for this flight record.')", true);
                return;
            }
            AddUpdate("INSERT",0);
            
        }

        private void AddUpdate(string strOperation, int recordId)
        {
            int retVal = 0;            
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION",strOperation));
                sqlParams.Add(new OleDbParameter("v_flight_record_id", recordId));
                sqlParams.Add(new OleDbParameter("v_flight_type_id",ddlFlightType0.SelectedValue));
                sqlParams.Add(new OleDbParameter("v_flight_year_id",ddlFlightYear0.SelectedValue));
                sqlParams.Add(new OleDbParameter("v_flight_inspector_id", ddlFlightInspector.SelectedValue));
                sqlParams.Add(new OleDbParameter("v_FLIGHT_RECORD_NAME", ""));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID",System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                
               

                //sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_FRC_FLIGHT_RECORD_INS_UPD, sqlParams);

            }
            catch(Exception ex)
            {
            }
            finally
            {
            }

            if (retVal == 1)
            {
                BindGrid();
                
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Flight record already exists')", true);
            }
        }


        private void AddUpdate(string strOperation, int recordId, string recordName,string inspector)
        {
            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("v_flight_record_id", recordId));
                sqlParams.Add(new OleDbParameter("v_flight_type_id", ddlFlightType0.SelectedValue));
                sqlParams.Add(new OleDbParameter("v_flight_year_id", ddlFlightYear0.SelectedValue));
                sqlParams.Add(new OleDbParameter("v_flight_inspector_id", inspector));
                sqlParams.Add(new OleDbParameter("v_FLIGHT_RECORD_NAME", recordName));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));



                //sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_FRC_FLIGHT_RECORD_INS_UPD, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                BindGrid();

                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Flight record already exists')", true);
            }
        }

        protected void gdv_list_RowEditing(object sender, GridViewEditEventArgs e)
        {
            gdv_list.EditIndex = e.NewEditIndex;
            BindGrid();
        }

        protected void gdv_list_RowUpdating(object sender, GridViewUpdateEventArgs e)
        {
            int recordid = Convert.ToInt32(gdv_list.DataKeys[e.RowIndex].Values["flight_record_id"].ToString());            
            TextBox txtRecordName = (TextBox)gdv_list.Rows[e.RowIndex].FindControl("txtRecordName");
            DropDownList ddlInspector = (DropDownList)gdv_list.Rows[e.RowIndex].FindControl("ddlInspector");
            if (txtRecordName.Text == "")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Flight record name cannot be empty.')", true);
                return;
            }
            if (ddlInspector.SelectedValue == "-1")
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Select Inspector for this flight record.')", true);
                return;
            }
            AddUpdate("UPDATE", recordid, txtRecordName.Text, ddlInspector.SelectedValue);
            gdv_list.EditIndex = -1;
            BindGrid();
        }

        protected void gdv_list_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            int recordid = Convert.ToInt32(gdv_list.DataKeys[e.RowIndex].Values["flight_record_id"].ToString());
            AddUpdate("DELETE", recordid);
        }

        protected void gdv_list_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            gdv_list.EditIndex = -1;
            BindGrid();
        }

        protected void ddlFlightYear0_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindGrid();
        }

        protected void ddlFlightType0_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindflightInspector();
            BindGrid();
        }

        protected void ddlFlightInspector_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindGrid();
        }

        protected void gdv_list_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow && gdv_list.EditIndex == e.Row.RowIndex)
            {
                int V_FLIGHT_TYPE_ID = Convert.ToInt32(DataBinder.Eval(e.Row.DataItem, "flight_type_id").ToString());
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_FLIGHT_TYPE_ID", V_FLIGHT_TYPE_ID));
                DropDownList ddlInspector = (DropDownList)e.Row.FindControl("ddlInspector");
                DataTable dt = DataAccessUtility.SelectDataTableViaStoreProcedureParam(m_SP_FRC_SELECT_FLIGHT_EMP, OledbParams);                
                ddlInspector.DataSource = dt;
                ddlInspector.DataTextField = "NAME";
                ddlInspector.DataValueField = "ID";
                ddlInspector.DataBind();
                string selectedInspector = DataBinder.Eval(e.Row.DataItem, "INSPECTOR").ToString();
                ddlInspector.Items.FindByValue(selectedInspector).Selected = true;
            }
        }

        protected void ddlFlightType0_DataBound(object sender, EventArgs e)
        {
            bindflightInspector();
        }
    }
}