﻿using DataAccess;
using System;
using System.Collections.Generic;
using System.Data.OleDb;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace VMT
{
    public partial class Flight_Inspector : System.Web.UI.Page
    {
        string m_SP_FI_SELECT_FLIGHT_EMP = Properties.Settings.Default.SP_FI_SELECT_FLIGHT_EMP;
        string m_SP_FI_SELECT_FLIGHT_RECORD = Properties.Settings.Default.SP_FI_SELECT_FLIGHT_RECORD;
        string m_SP_FI_SELECT_FLIGHT_EMP_L = Properties.Settings.Default.SP_FI_SELECT_FLIGHT_EMP_L;
        string m_SP_FI_SELECT_FLIGHT_RECORD_L = Properties.Settings.Default.SP_FI_SELECT_FLIGHT_RECORD_L;
        string m_SP_FI_SELECT_FLIGHT_INSPECTOR = Properties.Settings.Default.SP_FI_SELECT_FLIGHT_INSPECTOR;
        string m_SP_FI_INS_DEL_FLIGHT_INSPECTOR = Properties.Settings.Default.SP_FI_INS_DEL_FLIGHT_INSPECTOR;
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Flight Type Inspector Assignment";

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {

                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                BindFlightRecord();
                BindEmployee();
                BindListEmployee();
                BindListFlightRecord();
            }
        }

        void BindFlightRecord()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_FI_SELECT_FLIGHT_RECORD, ddl_FlightRecord);
            }
            catch
            {
            }
        }

        void BindEmployee()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_FI_SELECT_FLIGHT_EMP, ddl_Inspector);
            }
            catch
            {
            }
        }

        void BindListFlightRecord()
        {
            try
            {
                DataAccessUtility.BindListboxWithoutConditionViaProcedure(m_SP_FI_SELECT_FLIGHT_RECORD_L, lst_FlightRecord);
            }
            catch
            {
            }
        }

        void BindListEmployee()
        {
            try
            {
                DataAccessUtility.BindListboxWithoutConditionViaProcedure(m_SP_FI_SELECT_FLIGHT_EMP_L, lst_Employee);
            }
            catch
            {
            }
        }

        private void BindGrid()
        {
            gdvFlightInspector.DataBind();
            try
            {
                List<OleDbParameter> OleDbParams = new List<OleDbParameter>();

                OleDbParams.Add(new OleDbParameter("V_FLIGHT_TYPE_ID", Convert.ToInt32(ddl_FlightRecord.SelectedValue)));
                OleDbParams.Add(new OleDbParameter("V_FLIGHT_INSPECTOR_ID", ddl_Inspector.SelectedValue));


                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_FI_SELECT_FLIGHT_INSPECTOR, OleDbParams, gdvFlightInspector);
            }
            catch
            {
            }
        }

       

        protected void btnSave_Click(object sender, EventArgs e)
        {
            //AddUpdate("INSERT", 0);
            BindGrid();
        }

        protected void gdvFlightInspector_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            //int recordid = Convert.ToInt32(gdvFlightInspector.DataKeys[e.RowIndex].Values["OBJECTID"].ToString());
            //AddDelete("DELETE", recordid);
            //BindGrid();
        }

        private void AddDelete(string strOperation, int flightId, string inspectorId)
        {
            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                //sqlParams.Add(new OleDbParameter("V_OBJECTID", recordId));
                sqlParams.Add(new OleDbParameter("V_FLIGHT_TYPE_ID", flightId));
                sqlParams.Add(new OleDbParameter("V_FLIGHT_INSPECTOR_ID", inspectorId));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));



                //sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_FI_INS_DEL_FLIGHT_INSPECTOR, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                BindGrid();

                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Inspector already assigned to flight type')", true);
            }
        }

        protected void btn_addFlightRecord_Click(object sender, EventArgs e)
        {
            try
            {
                if (lst_FlightRecord.SelectedValue.ToString().Trim() != "0")
                {
                    foreach (ListItem item in this.lst_FlightRecord.Items)
                    {
                        if (item.Selected)
                        {
                            this.lst_selFlightRecord.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }


                    for (int i = lst_FlightRecord.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_FlightRecord.Items[i].Selected)
                        {
                            lst_FlightRecord.Items.RemoveAt(i);
                        }

                    }

                }
                else
                {
                    foreach (ListItem item in this.lst_FlightRecord.Items)
                    {
                        if (item.Value.ToString().Trim() != "0")
                        {
                            this.lst_selFlightRecord.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }

                    for (int i = lst_FlightRecord.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_FlightRecord.Items[i].Value.ToString() != "0")
                        {
                            lst_FlightRecord.Items.RemoveAt(i);
                        }

                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_remFlightRecord_Click(object sender, EventArgs e)
        {
            try
            {
                foreach (ListItem item in this.lst_selFlightRecord.Items)
                {
                    if (item.Selected)
                    {
                        this.lst_FlightRecord.Items.Add(new ListItem(item.Text, item.Value));
                    }
                }


                for (int i = lst_selFlightRecord.Items.Count - 1; i >= 0; i--)
                {
                    if (lst_selFlightRecord.Items[i].Selected)
                    {
                        lst_selFlightRecord.Items.RemoveAt(i);
                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_addEmp_Click(object sender, EventArgs e)
        {
            try
            {
                if (lst_Employee.SelectedValue.ToString().Trim() != "0")
                {
                    foreach (ListItem item in this.lst_Employee.Items)
                    {
                        if (item.Selected)
                        {
                            this.lst_selEmployee.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }


                    for (int i = lst_Employee.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_Employee.Items[i].Selected)
                        {
                            lst_Employee.Items.RemoveAt(i);
                        }

                    }

                }
                else
                {
                    foreach (ListItem item in this.lst_Employee.Items)
                    {
                        if (item.Value.ToString().Trim() != "0")
                        {
                            this.lst_selEmployee.Items.Add(new ListItem(item.Text, item.Value));
                        }
                    }

                    for (int i = lst_Employee.Items.Count - 1; i >= 0; i--)
                    {
                        if (lst_Employee.Items[i].Value.ToString() != "0")
                        {
                            lst_Employee.Items.RemoveAt(i);
                        }

                    }

                }
            }
            catch
            {
            }
        }

        protected void btn_remEmp_Click(object sender, EventArgs e)
        {
            try
            {
                foreach (ListItem item in this.lst_selEmployee.Items)
                {
                    if (item.Selected)
                    {
                        this.lst_Employee.Items.Add(new ListItem(item.Text, item.Value));
                    }
                }


                for (int i = lst_selEmployee.Items.Count - 1; i >= 0; i--)
                {
                    if (lst_selEmployee.Items[i].Selected)
                    {
                        lst_selEmployee.Items.RemoveAt(i);
                    }

                }
            }
            catch
            {
            }
        }

        protected void btnApply_Click(object sender, EventArgs e)
        {
            try
            {
                if (lst_selFlightRecord.Items.Count == 0)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('No Flight Type Selected!')", true);
                    return;
                }

                if (lst_selEmployee.Items.Count == 0)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('No Inspector Selected!')", true);
                    return;
                }


                foreach (ListItem itemC in this.lst_selEmployee.Items)
                {

                    foreach (ListItem itemW in this.lst_selFlightRecord.Items)
                    {
                        AddDelete("INSERT", Int32.Parse(itemW.Value), itemC.Value);

                    }

                }


                BindGrid();
                ResetControl();
            }
            catch
            {
            }
        }

        private void ResetControl()
        {
            lst_selEmployee.Items.Clear();
            lst_selFlightRecord.Items.Clear();
            BindListFlightRecord();
            BindListEmployee();
        }

    }
}