﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using DataAccess;

namespace VMT
{
    public partial class Emp_businessunit : System.Web.UI.Page
    {
        string m_SP_VDM_BUNIT_EMP_INS_DEL = Properties.Settings.Default.SP_VDM_BUNIT_EMP_INS_DEL;
        string m_SP_SELECT_BUSINESS_UNIT = Properties.Settings.Default.SP_SELECT_M_BUSINESS_UNIT;
        string m_SP_SELECT_BSUNIT_NOT_EMP = Properties.Settings.Default.SP_SELECT_BSUNIT_NOT_EMP;
        string m_SP_SELECT_BSUNIT_EMP = Properties.Settings.Default.SP_SELECT_BSUNIT_EMP;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        string pageName = "Employee Business Unit";

        protected void Page_Load(object sender, EventArgs e)
        {
            
            if (!Page.IsPostBack)
            {
                //checks user role
                //userRole = DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());

                if (userRole == "0")
                {
                    System.Web.HttpContext.Current.Response.Redirect("Default.aspx");
                }

                //userRole = DataAccessUtility.GetCurrentUserRoles(scanaId);
                //if (userRole == "Edit")
                //{
                //    btn_add.Visible = true;
                //    btn_delete.Visible = true;
                //}
                //else
                //{
                //    btn_add.Visible = false;
                //    btn_delete.Visible = false;
                //}

                bindBusinessUnit();
                bindBusinessUnitNotEmp();
                bindBusinessUnitExistingEmp();
            }
        }


        protected void btn_add_Click(object sender, EventArgs e)
        {
            AddUpdate("INSERT");
        }


        private void AddUpdate(string strOperation)
        {
            if ( ddl_BUnit.SelectedIndex == -1 )
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Choose Business Unit!')", true);
                ddl_BUnit.Focus();
                return;
            }
            int Employee_id = 0;
            if (strOperation == "DELETE")
            {
                if (lst_BUnitEmp.SelectedIndex == -1)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Choose Employee to Add')", true);
                    lst_BUnitEmp.Focus();
                    return;
                }
                else
                {
                    Employee_id = Int32.Parse( lst_BUnitEmp.SelectedValue);
                }
            }

            else
            {
                if (ddl_emp.SelectedIndex == -1)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Choose Employee!')", true);
                    ddl_emp.Focus();
                    return;
                }
                else
                {
                    Employee_id = Int32.Parse(ddl_emp.SelectedValue);
                }
            }
            
            



            int retVal = 0;
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_OPERATION", strOperation));
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_BUnit.SelectedValue.ToString()));
                sqlParams.Add(new OleDbParameter("V_EMPLOYEE_ID", Employee_id));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
              //  sqlParams.Add(new OleDbParameter("V_RETURN_VALUE", 1));
                retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_BUNIT_EMP_INS_DEL, sqlParams);

            }
            catch { }
            finally
            {
            }

            if (retVal == 1)
            {
                bindBusinessUnitNotEmp();
                bindBusinessUnitExistingEmp();
                
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('" + strOperation + " successful')", true);

            }
            else if (retVal == -1)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Company name already exists')", true);
            }

        }
        void bindBusinessUnit()
        {
            try
            {
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_SELECT_BUSINESS_UNIT, ddl_BUnit);
            }
            catch
            {
            }
        }
        void bindBusinessUnitNotEmp()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_BUnit.SelectedValue));
                DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_SELECT_BSUNIT_NOT_EMP, OledbParams, ddl_emp);
            }
            catch
            {
            }
        }
        void bindBusinessUnitExistingEmp()
        {
            try
            {
                List<OleDbParameter> OledbParams = new List<OleDbParameter>();
                OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", ddl_BUnit.SelectedValue));
                DataAccessUtility.BindListboxWithConditionViaProcedure(m_SP_SELECT_BSUNIT_EMP, OledbParams, lst_BUnitEmp);
            }
            catch
            {
            }
        }

        protected void ddl_BUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            bindBusinessUnitNotEmp();
            bindBusinessUnitExistingEmp();
        }

        protected void ddl_BUnit_DataBound(object sender, EventArgs e)
        {
            bindBusinessUnitNotEmp();
            bindBusinessUnitExistingEmp();
        }

        protected void btn_delete_Click(object sender, EventArgs e)
        {
            AddUpdate("DELETE");
        }
    }

}