﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Data.SqlClient;
using DataAccess;
using System.IO;
using System.Net;
using System.Xml.Linq;



namespace VMT
{
    public partial class Bid_Process : System.Web.UI.Page
    {
        string m_SP_VDM_SELECT_BID_PROCESS = Properties.Settings.Default.SP_VDM_SELECT_BID_PROCESS;
        string m_SP_VDM_SELECT_BSUNIT_STATUS = Properties.Settings.Default.SP_VDM_SELECT_BSUNIT_STATUS;
        string m_SP_VDM_SELECT_YEAR_BU_STATUS = Properties.Settings.Default.SP_VDM_SELECT_YEAR_BU_STATUS;
        string m_SP_VDM_SELECT_ALL_EVENTCODE = Properties.Settings.Default.SP_VDM_SELECT_ALL_EVENTCODE;
        string m_SP_VDM_SELECT_BIDOPEN_EVCODE = Properties.Settings.Default.SP_VDM_SELECT_BIDOPEN_EVCODE;
        string m_SP_VDM_SELECT_WORKAREA = Properties.Settings.Default.SP_VDM_SELECT_WORKAREA;
        string m_SP_VDM_BID_PROCESS_INS = Properties.Settings.Default.SP_VDM_BID_PROCESS_INS;
        string m_SP_VDM_BID_DETAILS_INS_DEL = Properties.Settings.Default.SP_VDM_BID_DETAILS_INS_DEL;
        string m_SP_VDM_SELECT_WA_BY_BU_YR_EC = Properties.Settings.Default.SP_VDM_SELECT_WA_BY_BU_YR_EC;
        string m_SP_UR_GET_USER_ACCESS = Properties.Settings.Default.SP_UR_GET_USER_ACCESS;
        //string scanaId = System.Web.HttpContext.Current.User.Identity.Name.ToUpper();
        string userRole = string.Empty;
        string pageName = "Bid Process Open";

        protected void Page_Load(object sender, EventArgs e)
        {
            
          

            ScriptManager scriptManager = ScriptManager.GetCurrent(this.Page);
            scriptManager.RegisterPostBackControl(this.btnExportExcel);
            if (!Page.IsPostBack)
            {


                //checks user role
                // userRole =  DataAccessUtility.GetRole(m_SP_UR_GET_USER_ACCESS, pageName);
                //userRole = CallUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName);
                if (Properties.Settings.Default.ENVMNT.ToString() == "LOCAL")
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Environment.UserName.ToUpper());
                }
                else
                {
                    userRole = VMT.UserRole.CallNewUserRoleWebService(m_SP_UR_GET_USER_ACCESS, pageName, System.Web.HttpContext.Current.User.Identity.Name.ToUpper());
                }

                if (userRole == "0")
                {
                    Response.Redirect("default.aspx");
                }
                else if (userRole == "2")
                {
                    btnSubmitBid.Visible = true;
                }
                else if (userRole == "3")
                {
                    btnSubmitBid.Visible = true;
                }
                else
                {
                    btnSubmitBid.Visible = false;
                }



                BindBusinessUnit();
                ddlBUnit.SelectedValue = Properties.Settings.Default.SELECTED_BUNIT;
                BindYear();
                ddlYear.SelectedValue = DateTime.Now.Year.ToString().Substring(DateTime.Now.Year.ToString().Length - 2);
                BindEventCode();
            //    BindAllWorkArea();

                              

                ViewState["BUnit"] = "0";
                ViewState["Year"] = "0";
                ViewState["EventCode"] = "";
                ViewState["WorkArea"] = "0";
                ViewState["BidId"] = "0";
                //BindBidProcess();
              
            }
        }

        private void BindBidProcess()
        {
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT", Int32.Parse(ViewState["BUnit"].ToString())));
                sqlParams.Add(new OleDbParameter("V_YEAR", Int32.Parse(ViewState["Year"].ToString())));
                sqlParams.Add(new OleDbParameter("V_EVENT_CODE", ViewState["EventCode"].ToString().Length == 0 ? 0 : Int32.Parse(ViewState["EventCode"].ToString())));
                sqlParams.Add(new OleDbParameter("V_WORK_AREA", ViewState["WorkArea"].ToString().Length == 0 ? 0 : Int32.Parse(ViewState["WorkArea"].ToString())));

                DataAccessUtility.BindGridViewWithConditionViaProcedure(m_SP_VDM_SELECT_BID_PROCESS, sqlParams, gdvBidProcess);
                ViewState["dataTable"] = gdvBidProcess.DataSource as DataSet;
                gdvBidProcess.SelectedIndex = -1;
                if (gdvBidProcess.Rows.Count > 0)
                    btnExportExcel.Visible = true;
                else
                    btnExportExcel.Visible = false;
            }
            catch
            {
            }
        }

        protected void gdvBidProcess_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            gdvBidProcess.PageIndex = e.NewPageIndex;
            BindBidProcess();
        }

        void BindBusinessUnit()
        {
            try
            {
            List<OleDbParameter> sqlParams = new List<OleDbParameter>();
            sqlParams.Add(new OleDbParameter("V_STATUS", 1));
            DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_BSUNIT_STATUS, sqlParams, ddlBUnit);
            }
            catch
            {
            }
        }

        void BindYear()
        {
            try
            {
            int V_BUSINESS_UNIT_ID = 0;
            V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
            List<OleDbParameter> sqlParams = new List<OleDbParameter>();
           
            sqlParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
            sqlParams.Add(new OleDbParameter("V_STATUS", 1));
            DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_YEAR_BU_STATUS, sqlParams, ddlYear);
            }
            catch
            {
            }
   
        }

        void BindAllEventCode()
        {
            try
            {
                //DropDownList ddlEventCode = (DropDownList)gdvBidProcess.HeaderRow.FindControl("ddlEventCode");
                DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_ALL_EVENTCODE, ddlEventCode);
            }
            catch
            {
            }
        }

        void BindAllWorkArea()
        {
            try
            {
            DataAccessUtility.BindDropdownListWithoutConditionViaProcedure(m_SP_VDM_SELECT_WORKAREA, ddlWorkArea);
            }
            catch
            {
            }
        }

        protected void ddlBUnit_SelectedIndexChanged(object sender, EventArgs e)
        {
            BindYear();
            BindEventCode();
            BindWorkArea();
        }

        protected void ddlYear_SelectedIndexChanged(object sender, EventArgs e)
        {
             BindEventCode();
             //BindWorkArea();
        }

        protected void ddlEventCode_SelectedIndexChanged(object sender, EventArgs e)
        {
             BindWorkArea();
        }

        void BindEventCode()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            try
            {
            V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
            V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);

            List<OleDbParameter> OledbParams = new List<OleDbParameter>();
            OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
            OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
            DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_BIDOPEN_EVCODE, OledbParams, ddlEventCode);
            }
            catch
            {
            }
        }

        void BindWorkArea()
        {
            int V_BUSINESS_UNIT_ID = 0;
            int V_YEAR = 0;
            int V_EVENT_CODE_ID = 0;
            try
            {
            V_BUSINESS_UNIT_ID = Convert.ToInt32(ddlBUnit.SelectedValue);
            V_YEAR = Convert.ToInt32(ddlYear.SelectedValue);
            V_EVENT_CODE_ID = Convert.ToInt32(ddlEventCode.SelectedValue);

            List<OleDbParameter> OledbParams = new List<OleDbParameter>();
            OledbParams.Add(new OleDbParameter("V_BUSINESS_UNIT_ID", V_BUSINESS_UNIT_ID));
            OledbParams.Add(new OleDbParameter("V_YEAR", V_YEAR));
            OledbParams.Add(new OleDbParameter("V_EVENT_CODE_ID", V_EVENT_CODE_ID));
            DataAccessUtility.BindDropdownListWithConditionViaProcedure(m_SP_VDM_SELECT_WA_BY_BU_YR_EC, OledbParams, ddlWorkArea);
            }
            catch
            {
            }
        }

        
        //protected void btn_go_Click(object sender, EventArgs e)
        //{
        //    ViewState["BUnit"] = ddlBUnit.SelectedValue;
        //    ViewState["Year"] = ddlYear.SelectedValue;
        //    ViewState["EventCode"] = ddlEventCode.SelectedValue;
        //    ViewState["WorkArea"] = ddlWorkArea.SelectedValue;
        //    BindBidProcess();
        //}

        protected void chkboxSelectAll_CheckedChanged(object sender, EventArgs e)
        {
            CheckBox ChkBoxHeader = (CheckBox)gdvBidProcess.HeaderRow.FindControl("cbSelectAll");
            foreach (GridViewRow row in gdvBidProcess.Rows)
            {
                CheckBox ChkBoxRows = (CheckBox)row.FindControl("cbSelect");
                if (ChkBoxHeader.Checked == true)
                {
                    ChkBoxRows.Checked = true;
                    txtDesc.Enabled = true;
                    btnSubmitBid.Enabled = true;
                }
                else
                {
                    ChkBoxRows.Checked = false;
                    txtDesc.Enabled = false;
                    btnSubmitBid.Enabled = false;
                }
            }
        }


        int retVal = 0;
        protected void btnSubmitBid_Click(object sender, EventArgs e)
        {
          
            if (txtDesc.Text.Length == 0)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Bid description could not be blank!')", true);
                txtDesc.Focus();
                return;
            }
            try
            {
                List<OleDbParameter> sqlParams = new List<OleDbParameter>();
                sqlParams.Add(new OleDbParameter("V_WORK_STATUS_ID", 2)); //Open bid=2
                sqlParams.Add(new OleDbParameter("V_BID_DESCRIPTION", txtDesc.Text.Trim()));
                sqlParams.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
               
                ViewState["BidId"] = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_BID_PROCESS_INS, sqlParams);
                if (Int32.Parse(ViewState["BidId"].ToString()) == -1)
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Bid Description alreday exists')", true);
                }
                else
                {
                     int insCnt = 0;
                     foreach (GridViewRow row in gdvBidProcess.Rows)
                     {
                         if (((CheckBox)row.FindControl("cbSelect")).Checked)
                         {
                             //txtDesc.Enabled = true;
                             //btnSubmitBid.Enabled = true;

                             //int V_WORK_AREA_ID = Convert.ToInt32((row.FindControl("lbl_WORK_AREA_ID") as Label).Text); 
                             //Label lbl = (Label)row.FindControl("lbl_WORK_AREA_ID");
                             int V_WORK_AREA_ID = Convert.ToInt32(((Label)row.FindControl("lbl_WORK_AREA_ID")).Text); 
                             List<OleDbParameter> sqlParamsBD = new List<OleDbParameter>();
                             sqlParamsBD.Add(new OleDbParameter("V_OPERATION", "INSERT"));
                             sqlParamsBD.Add(new OleDbParameter("V_BID_ID", ViewState["BidId"]));
                             sqlParamsBD.Add(new OleDbParameter("V_WORK_AREA_ID", V_WORK_AREA_ID));
                             sqlParamsBD.Add(new OleDbParameter("V_LAST_UPDATED_USER_ID", System.Web.HttpContext.Current.User.Identity.Name.Replace("SCANA\\", "").ToUpper()));
                             retVal = DataAccessUtility.InsertUpdateDeleteViaStoreProcedureParam(m_SP_VDM_BID_DETAILS_INS_DEL, sqlParamsBD);

                             if (retVal == 1)
                                 insCnt++;
                         }                     
                     }
                     if (insCnt > 0)
                     {
                       //  ScriptManager.RegisterStartupScript(this, this.GetType(), "alert", "alert('Bid created " + insCnt + " for work areas')", true);
                         BindBidProcess();
                         //txtDesc.Enabled = false;
                         //btnSubmitBid.Enabled = false;
                     }
                }
            }
        
            catch { }
            finally
            {
                txtDesc.Text = "";
            }
         }

        protected void btnExportExcel_Click(object sender, EventArgs e)
        {
            try
            {
             Dictionary<string, string> dictionaryFilters = new Dictionary<string, string>();
             dictionaryFilters.Add("Business Unit", ddlBUnit.SelectedItem.Text);
             dictionaryFilters.Add("Year", ddlYear.SelectedItem.Text);
             dictionaryFilters.Add("Event Code", ddlEventCode.SelectedItem.Text);
             dictionaryFilters.Add("Work Area", ddlWorkArea.SelectedItem.Text);
             List<int> listHideColumns= new List<int> (new int [] {4});
             VDMUtil.ExportGridToExcel(gdvBidProcess, "Bid Process","Bid_Process", dictionaryFilters, listHideColumns);
            }
            catch
            {
            }
         }

        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Confirms that an HtmlForm control is rendered for the specified ASP.NET
               server control at run time. */
        }
               

        //private string _sortDirection;
        protected void gdvBidProcess_Sorting(object sender, GridViewSortEventArgs e)
        {
            try
            {
            VDMUtil.GridviewSorting(gdvBidProcess, e.SortExpression, (DataSet)ViewState["dataTable"]);
            }
            catch
            {
            }
        }

        protected void ddlBUnit_DataBound(object sender, EventArgs e)
        {
            BindYear();
        }

        protected void ddlYear_DataBound(object sender, EventArgs e)
        {
            BindEventCode();
            //BindWorkArea();
        }

        protected void ddlWorkArea_SelectedIndexChanged(object sender, EventArgs e)
        {
            //if (ddlWorkArea.SelectedIndex != -1)
            //    btnGo.Enabled = true;
            ViewState["BUnit"] = ddlBUnit.SelectedValue;
            ViewState["Year"] = ddlYear.SelectedValue;
            ViewState["EventCode"] = ddlEventCode.SelectedValue;
            ViewState["WorkArea"] = ddlWorkArea.SelectedValue;
            BindBidProcess();
        }

        protected void ddlEventCode_DataBound(object sender, EventArgs e)
        {
            BindWorkArea();
        }

        protected void ddlWorkArea_DataBound(object sender, EventArgs e)
        {
            ViewState["BUnit"] = ddlBUnit.SelectedValue;
            ViewState["Year"] = ddlYear.SelectedValue;
            ViewState["EventCode"] = ddlEventCode.SelectedValue;
            ViewState["WorkArea"] = ddlWorkArea.SelectedValue;
            BindBidProcess();
        }

        //private string CallUserRoleWebService(string data1, string data2)
        //{
        
        //    string url = "";
        //    if (Request.IsLocal)
        //    {
        //        url = "http://localhost:58980/UserRoleService.asmx/GetRole";

        //    }
        //    string xmlData = "";
        //    string result = "";
        //    string strPost = "argStoredProcedureName=" + data1 + "&pageTitle=" + data2;
        //    StreamWriter myWriter = null;
        //    HttpWebRequest objRequest = (HttpWebRequest)WebRequest.Create(url);
        //    objRequest.Method = "POST";
        //    objRequest.Timeout = 200000; // this should be greater than IIS / web server's timeout
        //    objRequest.ContentLength = strPost.Length;
        //    objRequest.ContentType = "application/x-www-form-urlencoded";
        //    objRequest.KeepAlive = false;
        //    try
        //    {
        //        myWriter = new StreamWriter(objRequest.GetRequestStream());
        //        myWriter.Write(strPost);

        //    }
        //    catch (Exception e)
        //    {
        //        throw new Exception(e.ToString());
        //    }
        //    finally
        //    {
        //        myWriter.Close();
        //    }
        //    HttpWebResponse objResponse = (HttpWebResponse)objRequest.GetResponse();
        //    using (StreamReader sr = new StreamReader(objResponse.GetResponseStream()))
        //    {
        //        xmlData = sr.ReadToEnd();
        //        sr.Close();
        //        XDocument doc = XDocument.Parse(xmlData);
        //        result = doc.Root.Value;
        //    }
        //    return result;
        //}

       

      }

       
    }
